/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.PermissionsPanelLayout;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class PermissionsPanel
extends PermissionsPanelLayout
implements ExportPanel {
    private static final long serialVersionUID = -1930610404012797310L;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public PermissionsPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PermissionsPanel.this.doUpdateState();
            }
        };
        this.chkAll.addActionListener(listener);
        this.chkSelect.addActionListener(listener);
        this.chkUpdate.addActionListener(listener);
        this.chkInsert.addActionListener(listener);
        this.chkDelete.addActionListener(listener);
        this.chkTruncate.addActionListener(listener);
        this.chkTrigger.addActionListener(listener);
        this.chkReference.addActionListener(listener);
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Permissions_header") + "</html>");
        this.chkAll.setText(i18nManager.getTranslation("_All"));
        this.lblRoleAll.setText(i18nManager.getTranslation("_role"));
        this.lblRoleSelect.setText(i18nManager.getTranslation("_role"));
        this.lblRoleUpdate.setText(i18nManager.getTranslation("_role"));
        this.lblRoleInsert.setText(i18nManager.getTranslation("_role"));
        this.lblRoleDelete.setText(i18nManager.getTranslation("_role"));
        this.lblRoleTruncate.setText(i18nManager.getTranslation("_role"));
        this.lblRoleTrigger.setText(i18nManager.getTranslation("_role"));
        this.lblRoleReference.setText(i18nManager.getTranslation("_role"));
    }

    protected void doUpdateState() {
        this.txtRoleAll.setEnabled(this.chkAll.isSelected());
        this.txtRoleSelect.setEnabled(this.chkSelect.isSelected());
        this.txtRoleUpdate.setEnabled(this.chkUpdate.isSelected());
        this.txtRoleInsert.setEnabled(this.chkInsert.isSelected());
        this.txtRoleDelete.setEnabled(this.chkDelete.isSelected());
        this.txtRoleTruncate.setEnabled(this.chkTruncate.isSelected());
        this.txtRoleTrigger.setEnabled(this.chkTrigger.isSelected());
        this.txtRoleReference.setEnabled(this.chkReference.isSelected());
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Permissions");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setAllRole(this.getAllRole());
        this.parameters.setDeleteRole(this.getDeleteRole());
        this.parameters.setInsertRole(this.getInsertRole());
        this.parameters.setReferenceRole(this.getReferenceRole());
        this.parameters.setSelectRole(this.getSelectRole());
        this.parameters.setTriggerRole(this.getTriggerRole());
        this.parameters.setTruncateRole(this.getTruncateRole());
        this.parameters.setUpdateRole(this.getUpdateRole());
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        boolean enabled = this.parameters.canCreatetable();
        this.chkAll.setEnabled(enabled);
        this.chkSelect.setEnabled(enabled);
        this.chkUpdate.setEnabled(enabled);
        this.chkInsert.setEnabled(enabled);
        this.chkDelete.setEnabled(enabled);
        this.chkTruncate.setEnabled(enabled);
        this.chkTrigger.setEnabled(enabled);
        this.chkReference.setEnabled(enabled);
        if (this.parameters.getAllRole() != null) {
            this.txtRoleAll.setText(this.parameters.getAllRole());
            this.chkAll.setSelected(true);
        } else {
            this.chkAll.setSelected(false);
        }
        if (this.parameters.getSelectRole() != null) {
            this.txtRoleSelect.setText(this.parameters.getSelectRole());
            this.chkSelect.setSelected(true);
        } else {
            this.chkSelect.setSelected(false);
        }
        if (this.parameters.getUpdateRole() != null) {
            this.txtRoleUpdate.setText(this.parameters.getUpdateRole());
            this.chkUpdate.setSelected(true);
        } else {
            this.chkUpdate.setSelected(false);
        }
        if (this.parameters.getInsertRole() != null) {
            this.txtRoleInsert.setText(this.parameters.getInsertRole());
            this.chkInsert.setSelected(true);
        } else {
            this.chkInsert.setSelected(false);
        }
        if (this.parameters.getDeleteRole() != null) {
            this.txtRoleDelete.setText(this.parameters.getDeleteRole());
            this.chkDelete.setSelected(true);
        } else {
            this.chkDelete.setSelected(false);
        }
        if (this.parameters.getTruncateRole() != null) {
            this.txtRoleTruncate.setText(this.parameters.getTruncateRole());
            this.chkTruncate.setSelected(true);
        } else {
            this.chkTruncate.setSelected(false);
        }
        if (this.parameters.getTriggerRole() != null) {
            this.txtRoleTrigger.setText(this.parameters.getTriggerRole());
            this.chkTrigger.setSelected(true);
        } else {
            this.chkTrigger.setSelected(false);
        }
        if (this.parameters.getReferenceRole() != null) {
            this.txtRoleReference.setText(this.parameters.getReferenceRole());
            this.chkReference.setSelected(true);
        } else {
            this.chkReference.setSelected(false);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getSelectRole() {
        if (!this.chkSelect.isSelected()) {
            return null;
        }
        String role = this.txtRoleSelect.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getInsertRole() {
        if (!this.chkInsert.isSelected()) {
            return null;
        }
        String role = this.txtRoleInsert.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getUpdateRole() {
        if (!this.chkUpdate.isSelected()) {
            return null;
        }
        String role = this.txtRoleUpdate.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getDeleteRole() {
        if (!this.chkDelete.isSelected()) {
            return null;
        }
        String role = this.txtRoleDelete.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getTruncateRole() {
        if (!this.chkTruncate.isSelected()) {
            return null;
        }
        String role = this.txtRoleTruncate.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getReferenceRole() {
        if (!this.chkReference.isSelected()) {
            return null;
        }
        String role = this.txtRoleReference.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getTriggerRole() {
        if (!this.chkTrigger.isSelected()) {
            return null;
        }
        String role = this.txtRoleTrigger.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }

    public String getAllRole() {
        if (!this.chkAll.isSelected()) {
            return null;
        }
        String role = this.txtRoleAll.getText();
        if (StringUtils.isBlank((CharSequence)role)) {
            return null;
        }
        return role.trim();
    }
}

