/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.PostCreatingStatementPanelLayout;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class PostCreatingStatementPanel
extends PostCreatingStatementPanelLayout
implements ExportPanel {
    private static final long serialVersionUID = 7106687071248901180L;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public PostCreatingStatementPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.chkUsePostCreatingStatement.setEnabled(true);
        this.chkUsePostCreatingStatement.setSelected(false);
        this.txtPostCreatingStatement.setText("");
        this.txtPostCreatingStatement.setEnabled(false);
        this.chkUsePostCreatingStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PostCreatingStatementPanel.this.doChangeUsePostCreatingStatement();
            }
        });
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Post_creating_statement_header") + "</html>");
        this.chkUsePostCreatingStatement.setText(i18nManager.getTranslation("_Introducir_sentencia_a_ejecutar_tras_la_creacion_de_la_tabla"));
    }

    protected void doChangeUsePostCreatingStatement() {
        this.txtPostCreatingStatement.setEnabled(this.chkUsePostCreatingStatement.isSelected());
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Post_creating_statement");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setPostCreatingStatement(this.getPostCreatingStatement());
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        if (this.parameters.canCreatetable()) {
            this.chkUsePostCreatingStatement.setEnabled(true);
        } else {
            this.chkUsePostCreatingStatement.setEnabled(false);
        }
        if (this.parameters.getPostCreatingStatement() != null) {
            String statement = this.parameters.getPostCreatingStatement();
            this.chkUsePostCreatingStatement.setSelected(true);
            this.txtPostCreatingStatement.setText(statement);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getPostCreatingStatement() {
        if (this.chkUsePostCreatingStatement.isEnabled()) {
            String stmt = this.txtPostCreatingStatement.getText();
            if (StringUtils.isBlank((CharSequence)stmt)) {
                return null;
            }
            return stmt.trim();
        }
        return null;
    }
}

