/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.SelectTableNamePanelLayout;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTableNamePanel
extends SelectTableNamePanelLayout
implements ExportPanel {
    private static final Logger logger = LoggerFactory.getLogger(SelectTableNamePanel.class);
    private static final long serialVersionUID = 6269512983586358017L;
    private ExpressionPickerController deleteRowsFilterPicker;
    private FillTablesListTask task = null;
    private SQLBuilder sqlbuilder;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public SelectTableNamePanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
                SelectTableNamePanel.this.cancelTask();
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        });
    }

    private void initComponents() {
        this.rdoCreateTable.addActionListener(e -> this.onChangeRadioSelecion());
        this.rdoInsert.addActionListener(e -> this.onChangeRadioSelecion());
        this.rdoCreateTable.setSelected(true);
        this.rdoInsert.setEnabled(false);
        this.lstTables.setEnabled(false);
        this.chkDeleteRows.setEnabled(false);
        try {
            this.txtTableName.setText(this.parameters.getSourceFeatureStore().getName());
        }
        catch (Exception ex) {
            logger.warn("Can't set the default value for the table name", (Throwable)ex);
        }
        ExpressionEvaluatorSwingManager expressionEvaluatorSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.deleteRowsFilterPicker = expressionEvaluatorSwingManager.createExpressionPickerController((JTextComponent)this.txtDeleteRowsFilter, this.btnDeleteRowsFilter);
        this.deleteRowsFilterPicker.setEnabled(false);
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        swingManager.translate(this.lblHeader);
        swingManager.translate(this.lblWarningUseExistingTable, true);
        swingManager.translate((AbstractButton)this.rdoInsert);
        swingManager.translate(this.lblSelectTableName);
        swingManager.translate((AbstractButton)this.rdoCreateTable);
        swingManager.translate(this.lblSchema);
        swingManager.translate(this.lblTableName);
        swingManager.translate(this.lblCaseSensitiveNote, true);
        swingManager.translate((AbstractButton)this.chkDeleteRows);
        swingManager.translate(this.lblDeleteRowsFilter);
        swingManager.translate((JComponent)this.txtDeleteRowsFilter);
        swingManager.translate((AbstractButton)this.btnDeleteRowsFilter);
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancelRequest();
            this.task.getSimpleTaskStatus().remove();
            this.task = null;
        }
    }

    public boolean canCreateTable() {
        return this.rdoCreateTable.isSelected();
    }

    public String getSchema() {
        if (this.canCreateTable()) {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.txtSchema.getText(), null);
        }
        TableItem item = (TableItem)this.lstTables.getSelectedValue();
        JDBCStoreParameters tableParameter = item.getParams();
        if (tableParameter == null) {
            return null;
        }
        return tableParameter.getSchema();
    }

    public String getTableName() {
        if (this.canCreateTable()) {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.txtTableName.getText(), null);
        }
        TableItem item = (TableItem)this.lstTables.getSelectedValue();
        if (item == null) {
            return null;
        }
        JDBCStoreParameters tableParameter = item.getParams();
        if (tableParameter == null) {
            return null;
        }
        return tableParameter.getTable();
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Tablename");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setSchema(this.getSchema());
        this.parameters.setTableName(this.getTableName());
        this.parameters.setCanCreatetable(this.canCreateTable());
        if (this.canCreateTable()) {
            this.parameters.setDeleteRows(false);
            this.parameters.setDeleteRowsFilter(null);
        } else {
            this.parameters.setDeleteRows(this.chkDeleteRows.isSelected());
            this.parameters.setDeleteRowsFilter(this.deleteRowsFilterPicker.get());
        }
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String tablename = this.getTableName();
        if (tablename == null) {
            throw new ExportPanelValidationException(i18nManager.getTranslation("_The_name_of_table_cannot_be_empty"));
        }
        String schema = this.getSchema();
        if (this.sqlbuilder.support_schemas() && schema == null) {
            throw new ExportPanelValidationException(i18nManager.getTranslation("_The_name_of_schema_cannot_be_empty"));
        }
        if (this.rdoCreateTable.isSelected()) {
            String tablename_tr = this.parameters.fixIdentifier(tablename);
            if (!tablename_tr.equals(tablename)) {
                String msg = i18nManager.getTranslation("_The_name_entered_for_the_table_does_not_correspond_to_the_conditions_selected_in_the_previous_panel_You_want_it_to_be_corrected_automatically");
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                int resp = dialogs.confirmDialog(msg, i18nManager.getTranslation("_Warning"), 0, 2, "Exportto_Table_name_with_spaces_or_mixed_case");
                if (resp != 0) {
                    msg = i18nManager.getTranslation("El_nombre_de_tabla_contiene_caracteres no_validos");
                    throw new ExportPanelValidationException(msg);
                }
                tablename = tablename_tr;
                this.txtTableName.setText(tablename);
            }
            ListModel model = this.lstTables.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                TableItem item = (TableItem)model.getElementAt(i);
                if (!StringUtils.equals((CharSequence)schema, (CharSequence)item.getParams().getSchema()) || !StringUtils.equals((CharSequence)tablename, (CharSequence)item.getParams().getTable())) continue;
                String msg = i18nManager.getTranslation("_La_tabla_{0}_{1}_ya_existe_en_la_base_de_datos_Seleccione_la_opcion_de_insertar_registros_en_una_tabla_existente_para_a\u00f1adir_los_datos_a_esta_o_indique_otro_nombre", new String[]{schema, tablename});
                throw new ExportPanelValidationException(msg);
            }
        }
        return true;
    }

    public void enterPanel() {
        JDBCServerExplorerParameters explorerParameters = this.parameters.getExplorerParameters();
        if (explorerParameters == null) {
            this.processPanel.setButtonEnabled(1, false);
            return;
        }
        this.processPanel.setButtonEnabled(1, true);
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParameters.getExplorerName(), (DataServerExplorerParameters)explorerParameters);
            this.sqlbuilder = explorer.createSQLBuilder();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve the sqlbuilder", ex);
        }
        this.fillTablesList();
        this.rdoCreateTable.setSelected(this.parameters.canCreatetable());
        if (this.parameters.canCreatetable()) {
            if (this.parameters.getSchema() != null) {
                this.txtSchema.setText(this.parameters.getSchema());
                this.txtTableName.setText(this.parameters.getTableName());
            }
            this.chkDeleteRows.setSelected(false);
            this.deleteRowsFilterPicker.set(null);
        } else {
            String schema = this.parameters.getSchema();
            if (schema != null) {
                for (int i = 0; i < this.lstTables.getModel().getSize(); ++i) {
                    TableItem item = (TableItem)this.lstTables.getModel().getElementAt(i);
                    JDBCStoreParameters tableParameter = item.getParams();
                    if (!StringUtils.equals((CharSequence)tableParameter.getSchema(), (CharSequence)schema)) continue;
                    this.lstTables.setSelectedIndex(i);
                }
            }
            this.chkDeleteRows.setSelected(this.parameters.isDeleteRows());
            this.deleteRowsFilterPicker.set((Object)this.parameters.getDeleteRowsFilter());
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void onChangeRadioSelecion() {
        if (this.rdoCreateTable.isSelected()) {
            this.txtSchema.setEnabled(true);
            this.txtTableName.setEnabled(true);
            this.lstTables.setEnabled(false);
            this.chkDeleteRows.setEnabled(false);
            this.txtDeleteRowsFilter.setEnabled(false);
            this.btnDeleteRowsFilter.setEnabled(false);
        } else {
            this.txtSchema.setEnabled(false);
            this.txtTableName.setEnabled(false);
            this.lstTables.setEnabled(true);
            this.chkDeleteRows.setEnabled(true);
            this.txtDeleteRowsFilter.setEnabled(true);
            this.btnDeleteRowsFilter.setEnabled(true);
        }
    }

    private void fillTablesList() {
        JDBCServerExplorerParameters explorerParameters = this.parameters.getExplorerParameters();
        if (explorerParameters == null) {
            return;
        }
        this.cancelTask();
        this.task = new FillTablesListTask();
        this.task.setDaemon(true);
        this.task.start();
    }

    private class FillTablesListTask
    extends AbstractMonitorableTask {
        public FillTablesListTask() {
            super("Export");
        }

        protected SimpleTaskStatus getSimpleTaskStatus() {
            return (SimpleTaskStatus)this.getTaskStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JDBCServerExplorerParameters explorerParameters = SelectTableNamePanel.this.parameters.getExplorerParameters();
            if (SelectTableNamePanel.this.parameters.getExplorerParameters() == null) {
                return;
            }
            SimpleTaskStatus status = this.getSimpleTaskStatus();
            try {
                status.setAutoremove(true);
                DataManager dataManager = DALLocator.getDataManager();
                this.getSimpleTaskStatus().message("Connecting server");
                explorerParameters.setShowInformationDBTables(false);
                JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParameters.getExplorerName(), (DataServerExplorerParameters)explorerParameters);
                SwingUtilities.invokeAndWait(() -> {
                    if (SelectTableNamePanel.this.sqlbuilder.support_schemas()) {
                        SelectTableNamePanel.this.txtSchema.setText(SelectTableNamePanel.this.sqlbuilder.default_schema());
                    } else {
                        SelectTableNamePanel.this.txtSchema.setText("");
                        SelectTableNamePanel.this.txtSchema.setEnabled(false);
                    }
                });
                this.getSimpleTaskStatus().message("Retrieving tables");
                List parameters = explorer.list();
                ArrayList<TableItem> tables = new ArrayList<TableItem>();
                for (DataStoreParameters table : parameters) {
                    if (status.isCancelled()) {
                        status.cancel();
                        break;
                    }
                    tables.add(new TableItem((JDBCStoreParameters)table));
                }
                Collections.sort(tables);
                this.getSimpleTaskStatus().message("Add tables");
                DefaultListModel<TableItem> lmodel = new DefaultListModel<TableItem>();
                for (TableItem table : tables) {
                    lmodel.addElement(table);
                }
                SwingUtilities.invokeAndWait(() -> {
                    SelectTableNamePanel.this.lstTables.setModel(lmodel);
                    SelectTableNamePanel.this.rdoInsert.setEnabled(true);
                });
                status.message("finish");
                status.terminate();
            }
            catch (Exception ex) {
                logger.warn("Fail to fill tables list", (Throwable)ex);
                if (status.isCancellationRequested()) {
                    status.cancel();
                }
                if (status.isRunning()) {
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18nManager.getTranslation("_There_have_been_problems_filling_data_in_panel") + " (" + SelectTableNamePanel.this.getTitlePanel() + ")", null, i18nManager.getTranslation("_Warning"), 2, "ProblemsFillingTableNamePanel");
                }
            }
            finally {
                status.terminate();
                status.remove();
            }
        }
    }

    private static class TableItem
    implements Comparable<TableItem> {
        private JDBCStoreParameters params;
        private String label;

        public TableItem(String label, JDBCStoreParameters params) {
            this.params = params;
            this.label = label;
        }

        public TableItem(JDBCStoreParameters params) {
            this(StringUtils.isEmpty((CharSequence)params.getSchema()) ? params.getTable() : params.getSchema() + "." + params.getTable(), params);
        }

        public String toString() {
            return this.label;
        }

        public JDBCStoreParameters getParams() {
            return this.params;
        }

        @Override
        public int compareTo(TableItem o) {
            return this.label.compareTo(o.label);
        }
    }
}

