/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.amic.desktop.wizard.WizardPanel;
import org.amic.swing.FlatBorder;

public abstract class ProcessPanel
extends WizardPanel
implements Runnable {
    private static int T_PROGRESS_BAR = 0;
    private static int T_TEXT = 1;
    private static int T_EMPTY = 2;
    private Vector processes = new Vector();
    private JProgressBar pbTotal;
    private JButton init;
    private boolean executing = false;
    private boolean done = false;
    private boolean canCancel = true;
    private boolean startOnEnter = false;

    public ProcessPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public void willEnter() {
        this.removeAll();
        ResourceBundle rb = ResourceBundle.getBundle("org/amic/desktop/wizard/wizard");
        int i = 0;
        while (i < this.processes.size()) {
            SingleProcess sp = (SingleProcess)this.processes.elementAt(i);
            if (sp.getType() == T_TEXT) {
                this.addComp(sp.label);
                if (sp.getMultiple()) {
                    this.addComp(sp.listPane);
                }
            } else if (sp.getType() == T_PROGRESS_BAR) {
                this.addComp(sp.label);
                this.addComp(sp.progressBar);
            } else if (sp.getType() == T_EMPTY) {
                this.add(sp.emptySpace);
            }
            ++i;
        }
        if (this.processes.size() > 1) {
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            this.addComp(new JLabel(rb.getString("total")));
            this.pbTotal = new JProgressBar(0, 100);
            this.pbTotal.setBorder(new FlatBorder(1));
            this.pbTotal.setForeground(Color.RED);
            this.pbTotal.setStringPainted(true);
            this.pbTotal.setPreferredSize(new Dimension(100, 16));
            this.addComp(this.pbTotal);
        }
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        if (this.startOnEnter) {
            this.execute();
        } else {
            this.init = new JButton(rb.getString("start"));
            this.init.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ProcessPanel.this.execute();
                }
            });
            this.addComp(this.init);
        }
        this.add(Box.createVerticalGlue());
    }

    private void addComp(JComponent comp) {
        comp.setAlignmentX(0.0f);
        this.add(comp);
    }

    private void updateTotal() {
        if (this.processes.size() > 1) {
            long total = 0L;
            long step = 0L;
            int i = 0;
            while (i < this.processes.size()) {
                SingleProcess sp = (SingleProcess)this.processes.elementAt(i);
                total += sp.getTotal();
                step += sp.getStep();
                ++i;
            }
            this.pbTotal.setValue((int)(100L * step / total));
        }
    }

    public void addProcess(String title, long total) {
        this.processes.add(new SingleProcess(title, total));
    }

    public void addProcess(String title, boolean multiple, int height) {
        this.processes.add(new SingleProcess(title, multiple, height));
    }

    public void addEmptySpace(int height) {
        this.processes.add(new SingleProcess(height));
    }

    public void setMessage(int index, String message) {
        SingleProcess sp = (SingleProcess)this.processes.elementAt(index);
        sp.setLabel(message);
    }

    public void setStep(int index, long step) {
        SingleProcess sp = (SingleProcess)this.processes.elementAt(index);
        sp.setStep(step);
        this.updateTotal();
    }

    public boolean canContinue() {
        return this.done;
    }

    public boolean canComeBack() {
        return false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isDone() {
        return this.done;
    }

    public void done() {
        if (this.init != null) {
            this.init.setEnabled(false);
        }
        this.executing = true;
        this.done = true;
        this.getWizard().updateState();
    }

    public void execute() {
        this.executing = true;
        if (this.init != null) {
            this.init.setEnabled(false);
        }
        this.getWizard().updateState();
        new Thread(this).start();
    }

    public void setCanCancel(boolean value) {
        this.canCancel = value;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public void setStartOnEnter(boolean value) {
        this.startOnEnter = value;
    }

    public abstract void run();

    private class SingleProcess {
        private int type;
        private long total;
        private boolean multiple;
        public JLabel label;
        public JProgressBar progressBar;
        private DefaultListModel model;
        private JList list;
        public JScrollPane listPane;
        public Component emptySpace;

        public SingleProcess(String title, long total) {
            this.type = T_PROGRESS_BAR;
            this.total = total;
            this.label = new JLabel(title);
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorder(new FlatBorder(1));
            this.progressBar.setForeground(Color.GRAY);
            this.progressBar.setStringPainted(true);
            this.progressBar.setPreferredSize(new Dimension(100, 16));
        }

        public SingleProcess(String title, boolean multiple, int height) {
            this.type = T_TEXT;
            this.multiple = multiple;
            this.label = new JLabel(title);
            if (multiple) {
                this.model = new DefaultListModel();
                this.list = new JList(this.model);
                this.listPane = new JScrollPane(this.list);
                this.listPane.setPreferredSize(new Dimension(100, height));
                this.listPane.setMaximumSize(new Dimension(2000, height));
                ((DefaultListCellRenderer)this.list.getCellRenderer()).setOpaque(false);
            }
        }

        public SingleProcess(int height) {
            this.type = T_EMPTY;
            this.emptySpace = Box.createRigidArea(new Dimension(0, height));
        }

        public void setStep(long step) {
            if (this.type == T_PROGRESS_BAR) {
                this.progressBar.setValue((int)(100L * step / this.total));
            }
        }

        public void setLabel(String value) {
            if (this.type == T_PROGRESS_BAR || this.type == T_TEXT && !this.multiple) {
                this.label.setText(value);
            } else if (this.type == T_TEXT) {
                this.model.addElement(value);
                this.list.ensureIndexIsVisible(this.model.size() - 1);
                this.list.repaint();
            }
        }

        public long getTotal() {
            return this.total;
        }

        public long getStep() {
            if (this.type == T_PROGRESS_BAR) {
                return this.total / 100L * (long)this.progressBar.getValue();
            }
            return 0L;
        }

        public int getType() {
            return this.type;
        }

        public boolean getMultiple() {
            return this.multiple;
        }
    }
}

