/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.amic.desktop.wizard.IWizardPanel;
import org.amic.desktop.wizard.ProcessPanel;
import org.amic.desktop.wizard.WizardActionsPanel;
import org.amic.desktop.wizard.WizardList;
import org.amic.swing.FlatBorder;
import org.amic.swing.SwingUtil;

public class Wizard
extends JDialog {
    private JButton bBack;
    private JButton bNext;
    private JButton bFinish;
    private JButton bCancel;
    private JPanel cardPanel;
    private WizardList list;
    private WizardActionsPanel actions;
    private boolean isCanceled = false;
    private boolean processKey;
    private Properties properties;
    private WizardKeyListener wizardKeyListener = new WizardKeyListener();
    private ResourceBundle rb;

    public Wizard(Frame owner, String name) {
        super(owner, name + " [Wizard]", true);
        this.setDefaultCloseOperation(0);
        this.setBounds(SwingUtil.screenCenter(780, 500));
        this.properties = new Properties();
        this.rb = ResourceBundle.getBundle("org/amic/desktop/wizard/wizard");
        this.list = new WizardList();
        this.actions = new WizardActionsPanel(this.list);
        this.getContentPane().add((Component)this.actions, "West");
        JPanel bp = new JPanel();
        bp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bp.setLayout(new BoxLayout(bp, 0));
        bp.add(Box.createHorizontalGlue());
        this.bBack = new JButton("<<" + this.rb.getString("back"));
        this.bBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Wizard.this.back();
            }
        });
        bp.add(this.bBack);
        this.bNext = new JButton(this.rb.getString("next") + " >>");
        this.bNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Wizard.this.next();
            }
        });
        bp.add(this.bNext);
        this.bFinish = new JButton(this.rb.getString("finish"));
        this.bFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Wizard.this.finish();
            }
        });
        bp.add(this.bFinish);
        this.bCancel = new JButton(this.rb.getString("cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cancel();
            }
        });
        bp.add(this.bCancel);
        bp.add(Box.createRigidArea(new Dimension(10, 0)));
        this.getContentPane().add((Component)bp, "South");
        this.setResizable(false);
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.setBorder(new FlatBorder(0));
        this.getContentPane().add((Component)this.cardPanel, "Center");
    }

    public void addPanel(IWizardPanel pan) {
        this.cardPanel.add(pan.getComponent(), pan.getTitle());
        this.list.addPanel(pan);
        pan.setWizard(this);
    }

    public void putWProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getWProperty(Object key) {
        return this.properties.get(key);
    }

    public void start() {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, this.list.currentPanel().getTitle());
        this.list.currentPanel().willEnter();
        this.updateState();
        this.validate();
        this.onStarted();
        this.show();
    }

    public void back() {
        IWizardPanel wp = this.list.currentPanel();
        IWizardPanel wp2 = this.list.priorPanel(true);
        if (wp2 != null && wp2.canComeBack()) {
            wp.willExit();
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, wp2.getTitle());
            wp2.willEnter();
            this.updateState();
        }
    }

    public void next() {
        IWizardPanel wp2;
        IWizardPanel wp = this.list.currentPanel();
        if (wp.canContinue() && (wp2 = this.list.nextPanel(true)) != null) {
            wp.willExit();
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, wp2.getTitle());
            wp2.willEnter();
            this.updateState();
        }
    }

    public void finish() {
        IWizardPanel wp = this.list.currentPanel();
        if (wp.canContinue()) {
            wp.willExit();
            this.onFinished();
            this.hide();
        }
    }

    public void cancel() {
        int i = 0;
        while (i < this.list.size()) {
            this.list.getPanel(i).canceled();
            ++i;
        }
        this.isCanceled = true;
        if (this.list.currentPanel() instanceof ProcessPanel) {
            ((ProcessPanel)this.list.currentPanel()).done();
        } else {
            this.hide();
        }
    }

    public void updateState(boolean changes) {
        this.actions.updateActions();
        this.updateButtons();
        if (!(this.list.currentPanel() instanceof ProcessPanel) && changes) {
            int i = this.list.currentIndex() + 1;
            while (i < this.list.size()) {
                this.list.getPanel(i).invalidateControls();
                ++i;
            }
        }
        this.updateControls(this.list.currentPanel());
    }

    public void updateState() {
        this.updateState(false);
    }

    public void updateButtons() {
        if (this.list.currentPanel() instanceof ProcessPanel) {
            ProcessPanel pp = (ProcessPanel)this.list.currentPanel();
            this.bBack.setEnabled(!pp.isExecuting());
            this.bNext.setEnabled(false);
            this.bCancel.setEnabled(pp.canCancel());
            if (pp.isDone()) {
                if (this.isCanceled) {
                    this.bFinish.setText(this.rb.getString("canceled"));
                } else {
                    this.bFinish.setText(this.rb.getString("done"));
                }
                this.bFinish.setEnabled(true);
                this.bCancel.setEnabled(false);
            }
        } else {
            this.bBack.setEnabled(!this.list.isFirst() && this.list.priorPanel(false).canComeBack());
            this.bNext.setEnabled(!this.list.isLast() && this.list.currentPanel().canContinue() && this.list.nextPanel(false) != null);
            this.bFinish.setEnabled(this.list.isLast() && this.list.currentPanel().canContinue());
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setProcessKey(boolean value) {
        this.processKey = value;
    }

    protected void onStarted() {
    }

    protected void onFinished() {
    }

    private void updateControls(final IWizardPanel panel) {
        if (!SwingUtil.iterateComponents(panel.getComponent(), new SwingUtil.ComponentAction(){
            boolean focusDone = false;

            public boolean performAction(Component comp) {
                if (comp.isFocusable()) {
                    comp.removeKeyListener(Wizard.this.wizardKeyListener);
                    comp.addKeyListener(Wizard.this.wizardKeyListener);
                    if (!(!panel.getFocusFirstControl() || this.focusDone || comp instanceof JScrollPane || comp instanceof JViewport || comp instanceof JPanel || comp instanceof JLabel || comp instanceof JButton)) {
                        comp.requestFocus();
                        this.focusDone = true;
                    }
                }
                return this.focusDone;
            }
        })) {
            SwingUtil.iterateComponents(panel.getComponent(), new SwingUtil.ComponentAction(){
                boolean focusDone = false;

                public boolean performAction(Component comp) {
                    if (comp.isFocusable()) {
                        comp.removeKeyListener(Wizard.this.wizardKeyListener);
                        comp.addKeyListener(Wizard.this.wizardKeyListener);
                        if (!(!panel.getFocusFirstControl() || this.focusDone || comp instanceof JScrollPane || comp instanceof JViewport || comp instanceof JPanel)) {
                            comp.requestFocus();
                            this.focusDone = true;
                        }
                    }
                    return this.focusDone;
                }
            });
        }
    }

    private class WizardKeyListener
    implements KeyListener {
        private WizardKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            IWizardPanel wp = Wizard.this.list.currentPanel();
            Wizard.this.setProcessKey(true);
            if (keyEvent.getKeyCode() == 10 && wp.getResponseOnEnter()) {
                wp.enterKey();
                if (Wizard.this.processKey) {
                    if (Wizard.this.bNext.isEnabled()) {
                        Wizard.this.bNext.doClick();
                        keyEvent.consume();
                    } else if (Wizard.this.bFinish.isEnabled()) {
                        Wizard.this.bFinish.doClick();
                        keyEvent.consume();
                    }
                }
            } else if (keyEvent.getKeyCode() == 27 && wp.getResponseOnCancel()) {
                wp.escapeKey();
                if (Wizard.this.processKey) {
                    if (Wizard.this.bBack.isEnabled()) {
                        Wizard.this.bBack.doClick();
                        keyEvent.consume();
                    } else if (Wizard.this.bCancel.isEnabled()) {
                        Wizard.this.bCancel.doClick();
                        keyEvent.consume();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

