/*
 * Decompiled with CFR 0.152.
 */
package org.amic.properties;

import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.amic.properties.PropertiesTableModel;
import org.amic.util.edit.FormattedDocument;
import org.amic.util.edit.JFormattedTextField;
import org.amic.util.string.ClassFormatter;

public class FormatterEditor
extends DefaultCellEditor {
    private Object value;
    private PropertiesTableModel.Property prop;
    private Component coEditor;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FormatterEditor() {
        super(new JFormattedTextField());
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        PropertiesTableModel ptm = (PropertiesTableModel)table.getModel();
        this.prop = ptm.getRowByIndex(row);
        if (this.prop.jClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FormatterEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            JComboBox<Object> co = new JComboBox<Object>(this.prop.stripBooleanFormat());
            co.setSelectedItem(ClassFormatter.format(value, this.prop.format));
            this.coEditor = co;
            return co;
        }
        if (this.prop.validCount() > 0) {
            JComboBox co = new JComboBox(this.prop.getValids());
            co.setSelectedItem(ClassFormatter.format(value));
            co.setEditable(this.prop.editable);
            this.coEditor = co;
            return co;
        }
        JFormattedTextField co = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        co.setBorder(new LineBorder(Color.black));
        ((FormattedDocument)co.getDocument()).setClass(this.prop.jClass);
        if (value != null) {
            co.setText(this.prop.format == null ? ClassFormatter.format(value) : ClassFormatter.format(value, this.prop.format));
        }
        co.selectAll();
        this.coEditor = co;
        return co;
    }

    public Object getCellEditorValue() {
        try {
            String text = null;
            if (this.coEditor instanceof JTextField) {
                JTextField tf = (JTextField)this.coEditor;
                text = tf.getText();
            } else if (this.coEditor instanceof JCheckBox) {
                text = ((JCheckBox)this.coEditor).getText();
            } else if (this.coEditor instanceof JComboBox) {
                text = ((JComboBox)this.coEditor).getSelectedItem().toString();
            }
            return this.prop.format == null ? ClassFormatter.parse(text, this.prop.jClass) : ClassFormatter.parse(text, this.prop.jClass, this.prop.format);
        }
        catch (ParseException ex) {
            return super.getCellEditorValue();
        }
    }

    public boolean stopCellEditing() {
        try {
            JTextField tf = null;
            if (this.coEditor instanceof JTextField) {
                tf = (JTextField)this.coEditor;
            } else if (this.coEditor instanceof JComboBox) {
                tf = (JTextField)((JComboBox)this.coEditor).getEditor().getEditorComponent();
            }
            if (tf != null && tf.getText().length() > 0) {
                if (this.prop.format == null) {
                    ClassFormatter.parse(tf.getText(), this.prop.jClass);
                } else {
                    ClassFormatter.parse(tf.getText(), this.prop.jClass, this.prop.format);
                }
            }
            return super.stopCellEditing();
        }
        catch (ParseException ex) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

