/*
 * Decompiled with CFR 0.152.
 */
package org.amic.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.amic.swing.EditTableColumns;
import org.amic.swing.EditTableRows;

public class JEditTable
extends JTable {
    protected DBTableKeyListener keyListener = new DBTableKeyListener();
    protected boolean insertRowVisible = false;
    protected EditTableRows tableRows = null;
    protected EditTableColumns tableColumns = null;

    public JEditTable() {
        this(null);
    }

    public JEditTable(TableModel model) {
        this.addKeyListener(this.keyListener);
        if (model != null) {
            this.setModel(model);
        }
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        TableColumnModel tcm = this.getColumnModel();
        if (this.tableColumns != null) {
            int i = 0;
            while (i < tcm.getColumnCount()) {
                TableColumn col = tcm.getColumn(i);
                this.tableColumns.setColumnProperties(col);
                ++i;
            }
        }
        this.changeSelection(0, 0, false, false);
    }

    public void setTableRows(EditTableRows etb) {
        this.tableRows = etb;
    }

    public void setTableColumns(EditTableColumns etc) {
        this.tableColumns = etc;
    }

    private void doDeleteRow() {
        if (this.isEditing() || this.tableRows == null) {
            return;
        }
        TableModel ma = this.getModel();
        if (ma.getRowCount() == 1) {
            return;
        }
        int row = this.getSelectedRow();
        if (this.tableRows.deleteRow(ma, row)) {
            if (row > ma.getRowCount() - 1) {
                row = ma.getRowCount() - 1;
            }
            this.setRowSelectionInterval(row, row);
        }
    }

    public void doInsertRow() {
        int row;
        if (this.isEditing() || this.insertRowVisible || this.tableRows == null) {
            return;
        }
        TableModel ma = this.getModel();
        if (this.tableRows.insertRow(ma, row = this.getSelectedRow())) {
            this.setRowSelectionInterval(row, row);
            this.insertRowVisible = true;
        }
    }

    public void doAppendRow() {
        TableModel ma;
        if ((!this.insertRowVisible || this.tableRows != null) && this.tableRows.appendRow(ma = this.getModel())) {
            this.insertRowVisible = true;
        }
    }

    public class DBTableKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 127 && evt.getModifiers() == 2) {
                JEditTable.this.doDeleteRow();
                evt.consume();
            } else if (evt.getKeyCode() == 155 && evt.getModifiers() != 2) {
                JEditTable.this.doInsertRow();
                evt.consume();
            } else if (evt.getKeyCode() == 40) {
                if (JEditTable.this.getSelectedRow() == JEditTable.this.getModel().getRowCount() - 1) {
                    JEditTable.this.doAppendRow();
                }
            } else if (evt.getKeyCode() == 10 && evt.getModifiers() != 2) {
                evt.setKeyCode(9);
                int nextCol = JEditTable.this.getSelectedColumn() + 1;
                int nextRow = JEditTable.this.getSelectedRow();
                int maxCol = JEditTable.this.getColumnCount();
                int maxRow = JEditTable.this.getRowCount() - 1;
                if (nextCol >= maxCol) {
                    nextCol = 0;
                    if (++nextRow > maxRow) {
                        if (JEditTable.this.insertRowVisible) {
                            --nextRow;
                        } else {
                            JEditTable.this.doAppendRow();
                        }
                    }
                }
                while (!JEditTable.this.isCellEditable(nextRow, nextCol)) {
                    if (++nextCol < maxCol) continue;
                    nextCol = 0;
                    if (++nextRow <= maxRow) continue;
                    if (JEditTable.this.insertRowVisible) {
                        --nextRow;
                        continue;
                    }
                    JEditTable.this.doAppendRow();
                }
                if (JEditTable.this.isEditing()) {
                    JEditTable.this.cellEditor.stopCellEditing();
                }
                JEditTable.this.changeSelection(nextRow, nextCol, false, false);
                evt.consume();
            } else {
                JEditTable.this.insertRowVisible = false;
            }
        }
    }
}

