/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MetaData {
    private Connection con = null;
    private String driver;
    private String url;
    private String user;
    private String password;

    public MetaData(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public DatabaseMetaData getMetaData() {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public Connection getConnection() {
        if (this.con == null) {
            this.con = this.performConnection();
        }
        return this.con;
    }

    public ResultSet getTables() {
        try {
            return this.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public ResultSet getViews() {
        try {
            return this.getMetaData().getTables(null, null, null, new String[]{"VIEW"});
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public ResultSet getSystemTables() {
        try {
            return this.getMetaData().getTables(null, null, null, new String[]{"SYSTEM TABLE"});
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public ResultSet getColumns(String table) {
        try {
            return this.getMetaData().getColumns(null, null, table, null);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public ResultSet getPrimaryKeys(String table) {
        try {
            return this.getMetaData().getPrimaryKeys(null, null, table);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public ResultSet getIndexes(String table) {
        try {
            return this.getMetaData().getIndexInfo(null, null, table, false, false);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private Connection performConnection() {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        try {
            Connection con = DriverManager.getConnection(this.url, this.user, this.password);
            return con;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

