/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.jar;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;

public class JarLoader
extends URLClassLoader {
    private Attributes attributes;
    private URL url;

    public JarLoader(URL url) {
        super(new URL[]{url});
        this.url = url;
        this.attributes = null;
    }

    public Attributes getMainAttributes() throws IOException {
        if (this.attributes == null) {
            URL u = new URL("jar", "", this.url + "!/");
            JarURLConnection uc = (JarURLConnection)u.openConnection();
            this.attributes = uc.getMainAttributes();
        }
        return this.attributes;
    }

    public String getMainClassName() throws IOException {
        this.getMainAttributes();
        return this.attributes != null ? this.attributes.getValue(Attributes.Name.MAIN_CLASS) : null;
    }

    public String getVersion() throws IOException {
        this.getMainAttributes();
        return this.attributes != null ? this.attributes.getValue(Attributes.Name.SIGNATURE_VERSION) : null;
    }

    public Object invokeClass(String name, String method, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.loadClass(name);
        Method m = c.getMethod(method, args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(method);
        }
        if (m.getReturnType() == Void.TYPE) {
            try {
                m.invoke(null, new Object[]{args});
                return null;
            }
            catch (IllegalAccessException e) {}
        } else {
            try {
                return m.invoke(null, new Object[]{args});
            }
            catch (IllegalAccessException e) {
            }
        }
        return null;
    }
}

