/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.string;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Tokenizer {
    private Hashtable tokenTable;

    public Tokenizer(String string) {
        this(string, ";", ":");
    }

    public Tokenizer(String string, String delim, String pair) {
        StringTokenizer tok = new StringTokenizer(string, delim);
        this.tokenTable = new Hashtable();
        while (tok.hasMoreElements()) {
            String temp = tok.nextToken();
            int pos = temp.indexOf(pair);
            this.tokenTable.put(temp.substring(0, pos), temp.substring(pos + pair.length()));
        }
    }

    public String getValue(String key) {
        return (String)this.tokenTable.get(key);
    }

    public String getValue(String key, String defaultValue) {
        String value = this.getValue(key);
        return value == null ? defaultValue : value;
    }

    public void removeKey(String key) {
        this.tokenTable.remove(key);
    }

    public Enumeration getKeys() {
        return this.tokenTable.keys();
    }
}

