/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.table;

import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.amic.util.db.Converter;
import org.amic.util.edit.FormattedDocument;
import org.amic.util.edit.JFormattedTextField;

public class FormatterEditor
extends DefaultCellEditor {
    private String showPattern;
    private Class columnClass = null;
    private Object value;

    public FormatterEditor(String showPattern, Class columnClass) {
        super(new JFormattedTextField());
        this.showPattern = showPattern;
        this.columnClass = columnClass;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component co = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ((JComponent)co).setBorder(new LineBorder(Color.black));
        ((FormattedDocument)((JFormattedTextField)co).getDocument()).setClass(this.columnClass);
        this.value = value;
        String editPattern = this.showPattern;
        if (value != null && value instanceof Number) {
            editPattern = "#.####";
        }
        ((JTextField)co).setText(new Converter(value).format(editPattern));
        ((JTextField)co).selectAll();
        return co;
    }

    public Object getCellEditorValue() {
        try {
            return new Converter(this.value).setString(((JTextField)this.getComponent()).getText(), this.showPattern).getValue();
        }
        catch (ParseException ex) {
            return super.getCellEditorValue();
        }
    }

    public boolean stopCellEditing() {
        try {
            String editPattern = this.showPattern;
            if (this.value != null && this.value instanceof Number) {
                editPattern = "#.####";
            }
            if (((JTextField)this.getComponent()).getText().length() > 0) {
                new Converter(this.value).setString(((JTextField)this.getComponent()).getText(), editPattern);
            }
            return super.stopCellEditing();
        }
        catch (ParseException ex) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
    }
}

