/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.zip;

import java.io.File;
import java.util.Date;
import org.amic.util.string.FilePath;
import org.amic.util.zip.DateFileName;

public class Cleaner {
    private String dateFormat;

    public Cleaner(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Cleaner() {
        this("yyyyMMddHHmm");
    }

    public void goOn(String dirName, String pattern) {
        this.dirFunc(dirName, pattern, new Date());
    }

    public void goOn(String dirName, String pattern, Date date) {
        this.dirFunc(dirName, pattern, date);
    }

    private void dirFunc(String dirName, String pattern, Date date) {
        File dirObj = new File(dirName);
        if (dirObj.exists()) {
            if (dirObj.isDirectory()) {
                File[] fileList = dirObj.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        this.dirFunc(fileList[i].getPath(), pattern, date);
                    } else if (fileList[i].isFile()) {
                        this.delFunc(fileList[i].getPath(), pattern, date);
                    }
                    ++i;
                }
            } else {
                this.delFunc(dirObj.getPath(), pattern, date);
            }
        }
    }

    private void delFunc(String dirName, String pattern, Date date) {
        DateFileName fn = new DateFileName(this.dateFormat);
        String fileName = FilePath.removePath(dirName);
        if (fn.itMatches(pattern, fileName) && fn.getFileName(pattern, date).compareTo(fileName) > 0) {
            new File(dirName).delete();
        }
    }
}

