/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.zip;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DateFileName {
    private String dateFormat;

    public DateFileName(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateFileName() {
        this("yyyyMMddHHmm");
    }

    public String getFileName(String pattern) {
        return this.getFileName(pattern, new Date());
    }

    public String getFileName(String pattern, Date date) {
        int p = pattern.indexOf("*");
        if (p > -1) {
            SimpleDateFormat df = new SimpleDateFormat();
            df.applyPattern(this.dateFormat);
            return pattern.substring(0, p) + df.format(date).toString() + pattern.substring(p + 1);
        }
        return pattern;
    }

    public boolean itMatches(String pattern, String fileName) {
        int p = pattern.indexOf("*");
        return Pattern.matches("^" + pattern.substring(0, p) + "[0-9]{" + this.dateFormat.length() + "}" + pattern.substring(p + 1) + "$", fileName);
    }
}

