/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.amic.util.string.FilePath;
import org.amic.util.zip.DateFileName;
import org.amic.util.zip.ZipParameter;

public class Zipper {
    private String dateFormat;
    private FileOutputStream fos;
    private ZipOutputStream zos;

    public Zipper(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Zipper() {
        this("yyyyMMddHHmm");
    }

    public void goOn(String zipName, String dirName) throws IOException {
        this.goOn(zipName, new ZipParameter[]{new ZipParameter(new String[]{dirName}, null, null)});
    }

    public void goOn(String zipName, ZipParameter[] obj) throws IOException {
        if ((zipName = new DateFileName(this.dateFormat).getFileName(zipName)).indexOf(".") == -1) {
            zipName = zipName + ".zip";
        }
        this.fos = new FileOutputStream(zipName);
        this.zos = new ZipOutputStream(this.fos);
        int i = 0;
        while (i < obj.length) {
            int j = 0;
            while (j < obj[i].dirName.length) {
                this.dirFunc(obj[i].dirName[j], obj[i], j);
                ++j;
            }
            ++i;
        }
        this.zos.flush();
        this.zos.close();
        this.fos.close();
    }

    private void dirFunc(String dirName, ZipParameter obj, int index) throws IOException {
        File dirObj = new File(dirName);
        if (dirObj.exists()) {
            String path = dirObj.getPath();
            if (dirObj.isDirectory()) {
                File[] fileList = dirObj.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    path = fileList[i].getPath();
                    if (fileList[i].isDirectory()) {
                        this.dirFunc(path, obj, index);
                    } else if (fileList[i].isFile() && obj.pasFilters(path)) {
                        this.zipFunc(path);
                    }
                    ++i;
                }
            } else if (obj.pasFilters(path)) {
                this.zipFunc(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zipFunc(String filePath) throws IOException {
        int byteCount;
        FileInputStream fis = new FileInputStream(filePath);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipEntry zipEntry = new ZipEntry(FilePath.removeDrive(filePath));
        this.zos.putNextEntry(zipEntry);
        byte[] data = new byte[4096];
        while ((byteCount = bis.read(data, 0, 4096)) > -1) {
            void var6_6;
            this.zos.write(data, 0, (int)var6_6);
        }
    }
}

