/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import org.amic.xml.NodeSet;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlReader;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XPathFinder {
    private XmlReader root;
    private XmlMapper mapper;
    private NodeSet set;

    public XPathFinder(XmlReader reader) {
        this(reader, new NodeSet(), null);
    }

    public XPathFinder(XmlReader reader, XmlMapper mapper) {
        this(reader, new NodeSet(), mapper);
    }

    public XPathFinder(XmlReader reader, NodeSet set) {
        this(reader, set, null);
    }

    public XPathFinder(XmlReader reader, NodeSet set, XmlMapper mapper) {
        this.root = reader;
        this.set = set;
        this.mapper = mapper;
    }

    public XmlReader findNode(String expression) {
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.root.getInternalNode(), (String)expression);
            if (node instanceof Element) {
                XmlReader tmp = new XmlReader(node);
                tmp.setMapper(this.mapper);
                this.set.addNode(tmp);
                return tmp;
            }
        }
        catch (Exception ex) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public NodeSet findNodes(String expression) {
        try {
            Node node;
            NodeIterator ni = XPathAPI.selectNodeIterator((Node)this.root.getInternalNode(), (String)expression);
            while ((node = ni.nextNode()) != null) {
                void var3_5;
                if (!(var3_5 instanceof Element)) continue;
                XmlReader tmp = new XmlReader((Node)var3_5);
                tmp.setMapper(this.mapper);
                this.set.addNode(tmp);
            }
            return this.set;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object eval(String expression) {
        try {
            XObject xo = XPathAPI.eval((Node)this.root.getInternalNode(), (String)expression);
            if (xo instanceof XNumber) {
                return new Double(((XNumber)xo).num());
            }
            if (xo instanceof XString) {
                return ((XString)xo).str();
            }
            if (xo instanceof XBoolean) {
                return new Boolean(((XBoolean)xo).bool());
            }
        }
        catch (Exception ex) {}
        return null;
    }
}

