/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.io.ByteArrayInputStream;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlReader;
import org.amic.xml.XmlWait;
import org.amic.xml.XmlWriter;

public abstract class XmlNodeTask
implements Runnable {
    private JTree tree;
    private DefaultMutableTreeNode node;

    public XmlNodeTask(JTree tree, DefaultMutableTreeNode node) {
        this.tree = tree;
        this.node = node;
        node.removeAllChildren();
        ((XmlReader)node.getUserObject()).getWriter().removeChildren();
        XmlWait.addWaiting(tree, node);
    }

    public XmlReader getXmlReader() {
        return (XmlReader)this.node.getUserObject();
    }

    public XmlWriter getPathToNode() {
        XmlReader xr = (XmlReader)this.node.getUserObject();
        try {
            return new XmlReader(new ByteArrayInputStream(xr.getWriter().getXMLToNode().getBytes())).getWriter();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void updateXmlNode(XmlReader response) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XmlNodeTask.this.node.removeAllChildren();
                XmlNodeTask.this.tree.updateUI();
            }
        });
        XmlReader reader = (XmlReader)this.node.getUserObject();
        reader.getWriter().removeChildren();
        if (response == null) {
            return;
        }
        NodeSet ns = response.getNodeSet();
        while (ns.hasNextNode()) {
            reader.getWriter().addNode(ns.nextNode());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XmlNodeTask.this.node.removeAllChildren();
                TreePath tp = new TreePath(XmlNodeTask.this.node.getPath());
                XmlNodeTask.this.tree.collapsePath(tp);
                XmlNodeTask.this.processChildren(XmlNodeTask.this.node);
                if (XmlNodeTask.this.node.getChildCount() > 0) {
                    XmlNodeTask.this.tree.expandPath(tp);
                }
                XmlNodeTask.this.tree.updateUI();
            }
        });
    }

    public void updateXmlNode(XmlReader response, String[] name) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XmlNodeTask.this.node.removeAllChildren();
                XmlNodeTask.this.tree.updateUI();
            }
        });
        XmlReader reader = (XmlReader)this.node.getUserObject();
        reader.getWriter().removeChildren();
        if (response == null) {
            return;
        }
        int i = 0;
        while (i < name.length) {
            NodeSet ns = response.getNodesByName(name[i]);
            while (ns.hasNextNode()) {
                reader.getWriter().addNode(ns.nextNode());
            }
            ++i;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XmlNodeTask.this.node.removeAllChildren();
                TreePath tp = new TreePath(XmlNodeTask.this.node.getPath());
                XmlNodeTask.this.tree.collapsePath(tp);
                XmlNodeTask.this.processChildren(XmlNodeTask.this.node);
                if (XmlNodeTask.this.node.getChildCount() > 0) {
                    XmlNodeTask.this.tree.expandPath(tp);
                }
                XmlNodeTask.this.tree.updateUI();
            }
        });
    }

    private void processChildren(DefaultMutableTreeNode node) {
        XmlReader n = (XmlReader)node.getUserObject();
        NodeSet nodes = n.getNodeSet();
        while (nodes.hasNextNode()) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodes.nextNode());
            node.add(newNode);
            this.processChildren(newNode);
        }
    }

    public static boolean test(DefaultMutableTreeNode node, String name) {
        XmlReader reader = (XmlReader)node.getUserObject();
        return reader.getNodeCount() == 0 && !XmlWait.test(node) && reader.getName().equals(name);
    }

    public static boolean test(DefaultMutableTreeNode node) {
        XmlReader reader = (XmlReader)node.getUserObject();
        return reader.getNodeCount() == 0 && !XmlWait.test(node);
    }
}

