/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.amic.util.icons.Icons;
import org.amic.xml.XmlReader;

public class XmlTreeCellRenderer
extends DefaultTreeCellRenderer {
    private String path;
    private String extension;

    public XmlTreeCellRenderer(String path, String extension) {
        this.path = path;
        this.extension = extension;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Icon icon = null;
        if (node.getUserObject() instanceof XmlReader) {
            XmlReader xr = (XmlReader)node.getUserObject();
            try {
                icon = Icons.getIcon(this.getClass(), this.path + "/" + xr.getName() + this.extension);
            }
            catch (Exception ex) {
                icon = null;
            }
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        return this;
    }
}

