/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.csv.simplereaders.CSVReaderSuperCSV;
import org.gvsig.fmap.dal.store.csv.simplereaders.FixedLenReader;
import org.gvsig.fmap.dal.store.simplereader.AutomaticDetectionOfTypes;
import org.gvsig.fmap.dal.store.simplereader.FieldTypeParser;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderPointAttributeEmulator;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFeatureTypeLoader
extends SimpleReaderFeatureTypeLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVFeatureTypeLoader.class);

    public CSVFeatureTypeLoader(CSVStoreParameters parameters) {
        super((SimpleReaderStoreParameters)parameters);
    }

    protected String getProviderName() {
        return "CSV";
    }

    protected SimpleReader getSimpleReader(Reader in) throws IOException {
        Object reader = CSVStoreParameters.getRawFieldsDefinition((DynObject)this.parameters) != null ? new FixedLenReader(in, (CSVStoreParameters)this.parameters) : new CSVReaderSuperCSV(in, (CSVStoreParameters)this.parameters);
        return reader;
    }

    protected boolean isFirstLineHeader() {
        return CSVStoreParameters.isFirstLineHeader((DynObject)this.parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] getHeaders(SimpleReader reader) throws RuntimeException, IOException {
        String[] headers = CSVStoreParameters.getHeaders((DynObject)this.parameters);
        if (headers == null) {
            if (!CSVStoreParameters.isFirstLineHeader((DynObject)this.parameters)) return this.getFixedHeaders(reader.getColumnsCount());
            headers = reader.getHeader();
            if (headers != null) return headers;
            if (CSVStoreParameters.getIgnoreErrors((DynObject)this.parameters)) {
                return this.getFixedHeaders(reader.getColumnsCount());
            }
            String msg = "Can't retrieve header from csv file '" + this.parameters.getFile().getAbsolutePath() + "' and not specified in the parameters.";
            LOGGER.warn(msg);
            throw new RuntimeException(msg);
        }
        if (!CSVStoreParameters.isFirstLineHeader((DynObject)this.parameters)) return headers;
        reader.getHeader();
        return headers;
    }

    protected void fillFeatureType(EditableFeatureType fType, String[] headers, AutomaticDetectionOfTypes.DetectedValue[] automaticTypes) {
        String fullFileName = this.parameters.getFile() == null ? "" : this.parameters.getFile().getAbsolutePath();
        String providerName = this.getProviderName();
        fType.setHasOID(true);
        FieldTypeParser[] fieldTypes = this.getFieldTypes(headers, automaticTypes);
        this.fillFeatureType(fType, fieldTypes);
        this.makeGeometry(fType, providerName, fullFileName);
        this.declareGeometryType(fType, fullFileName);
    }

    private void declareGeometryType(EditableFeatureType fType, String fullFileName) throws LocatorException {
        EditableFeatureAttributeDescriptor attr;
        String geometry_column = CSVStoreParameters.getGeometryColumn((DynObject)this.parameters);
        if (!StringUtils.isEmpty((CharSequence)geometry_column) && (attr = (EditableFeatureAttributeDescriptor)fType.get(geometry_column)) != null) {
            if (attr.getType() != 66) {
                attr.setDataType(66);
            }
            GeometryManager geommgr = GeometryLocator.getGeometryManager();
            try {
                GeometryType gt = geommgr.getGeometryType(CSVStoreParameters.getGeometryType((DynObject)this.parameters), CSVStoreParameters.getGeometrySubType((DynObject)this.parameters));
                attr.setGeometryType(gt);
            }
            catch (Exception e) {
                LOGGER.warn("Can't set geometry type for the calculated field in CSV file '" + fullFileName + "'.", (Throwable)e);
            }
            fType.setDefaultGeometryAttributeName(geometry_column);
        }
    }

    private void makeGeometry(EditableFeatureType fType, String providerName, String fullFileName) throws LocatorException {
        String[] pointDimensionNames = CSVStoreParameters.getPointDimensionNames((DynObject)this.parameters);
        if (pointDimensionNames != null) {
            SimpleReaderPointAttributeEmulator emulator = new SimpleReaderPointAttributeEmulator(pointDimensionNames);
            String columnName = CSVStoreParameters.getPointColumnName((DynObject)this.parameters);
            if (StringUtils.isBlank((CharSequence)columnName)) {
                columnName = "geom";
            }
            EditableFeatureAttributeDescriptor attr = fType.add(columnName, 66, (FeatureAttributeEmulator)emulator);
            GeometryManager geommgr = GeometryLocator.getGeometryManager();
            try {
                GeometryType gt = emulator.getFieldNames() != null && emulator.getFieldNames().length <= 2 ? geommgr.getGeometryType(0, 0) : geommgr.getGeometryType(0, 1);
                attr.setGeometryType(gt);
            }
            catch (Exception e) {
                LOGGER.warn("Can't set geometry type for the calculated field in '" + providerName + "' file '" + fullFileName + "'.", (Throwable)e);
            }
        }
    }
}

