/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.simplereaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.gvsig.tools.dynobject.DynObject;

public class FixedLenReader
implements SimpleReader {
    BufferedReader reader = null;
    SimpleReaderStoreParameters.FieldDefinition[] fieldsDefinition = null;
    List fields = null;
    private final int fieldCount;
    private final String commentStartMarker;
    private int currentLine = 1;

    public FixedLenReader(Reader reader, CSVStoreParameters parameters) {
        this.reader = new BufferedReader(reader);
        this.fieldsDefinition = CSVStoreParameters.getFieldsDefinition((DynObject)parameters);
        this.fieldCount = this.fieldsDefinition.length;
        this.fields = new ArrayList(this.fieldCount);
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fields.add(null);
        }
        this.commentStartMarker = CSVStoreParameters.getCommentStartMarker((DynObject)parameters);
    }

    public String[] getHeader() throws IOException {
        String[] header = new String[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            header[i] = Character.toString((char)(i + 65)).toUpperCase();
        }
        return header;
    }

    public int getColumnsCount() throws IOException {
        return this.fieldCount;
    }

    public List<String> read() throws IOException {
        String line = this.reader.readLine();
        ++this.currentLine;
        while (!StringUtils.isEmpty((CharSequence)line) && !StringUtils.isEmpty((CharSequence)this.commentStartMarker) && line.startsWith(this.commentStartMarker)) {
            line = this.reader.readLine();
            ++this.currentLine;
        }
        return this.parse(line);
    }

    public List<String> parse(String line) throws IOException {
        if (line == null) {
            return null;
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            SimpleReaderStoreParameters.FieldDefinition fieldDefinition = this.fieldsDefinition[i];
            String value = null;
            try {
                value = fieldDefinition.getToEndOfLine() ? line.substring(fieldDefinition.getStart()) : line.substring(fieldDefinition.getStart(), fieldDefinition.getEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fields.set(i, value);
        }
        return this.fields;
    }

    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    public List<String> skip(int lines) throws IOException {
        String line = null;
        for (int i = 0; i < lines; ++i) {
            line = this.reader.readLine();
            ++this.currentLine;
            while (line != null && this.commentStartMarker != null && line.startsWith(this.commentStartMarker)) {
                line = this.reader.readLine();
                ++this.currentLine;
            }
        }
        return this.parse(line);
    }

    public int getLine() {
        return this.currentLine;
    }

    public List<String> nextRowValues() {
        try {
            return this.read();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

