/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.virtualrows;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.store.csv.virtualrows.AbstractCSVList;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public class ApacheCommonsCSVList
extends AbstractCSVList {
    public ApacheCommonsCSVList(File text, File index, Charset charset) throws IOException {
        super(text, index, charset);
    }

    public ApacheCommonsCSVList(RandomAccessFileReader reader, RandomAccessFileIndex index) throws IOException {
        super(reader, index);
    }

    @Override
    protected List<String> nextRecord() throws IOException {
        CSVParser parser = CSVFormat.EXCEL.parse((Reader)this.reader);
        Iterator it = parser.iterator();
        if (!it.hasNext()) {
            return null;
        }
        CSVRecord record = (CSVRecord)it.next();
        ArrayList<String> values = new ArrayList<String>();
        for (String value : record) {
            values.add(value);
        }
        return values;
    }

    public static void main(String[] args) throws Exception {
        new DefaultLibrariesInitializer().fullInitialize();
        String fname = "/home/jjdelcerro/Descargas/test/origen_coordenadas.csv";
        File data_file = new File(fname);
        File index_file = new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + ".idx");
        TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
        taskStatusManager.addObserver((observable, notification) -> {
            TaskStatus status = taskStatusManager.getRunningTaskStatusMostRecent();
        });
        SimpleTaskStatus status = taskStatusManager.createDefaultSimpleTaskStatus(data_file.getName());
        status.add();
        RandomAccessFileReader reader = new RandomAccessFileReader(data_file, "UTF-8");
        RandomAccessFileIndex index_lines = reader.createOrOpenIndexOfLines(index_file, RandomAccessFileReader.FILTER_NONE, null);
        ApacheCommonsCSVList csv = new ApacheCommonsCSVList(reader, index_lines);
        System.out.println("Lines " + csv.size());
        int n = 0;
        for (List record : csv) {
            if (n < 100) {
                System.out.println(String.format("%6d: %s", n, ArrayUtils.toString((Object)record)));
            } else if (n == 100) {
                System.out.println("More records...");
            }
            ++n;
        }
        System.out.println("-----------------");
        long t1 = new Date().getTime();
        for (int i = csv.size() - 1; i >= 0; --i) {
            List record = (List)csv.get(i);
            if (i < 100) {
                System.out.println(String.format("%6d: %s", i, ArrayUtils.toString((Object)record)));
                continue;
            }
            if (i != 100) continue;
            System.out.println("More records...");
        }
        long t2 = new Date().getTime();
        System.out.println("Time: " + (t2 - t1) + " ms");
        IOUtils.closeQuietly((Closeable)csv);
    }
}

