/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.virtualrows;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.store.csv.virtualrows.AbstractCSVList;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class SuperCSVList
extends AbstractCSVList {
    private CsvPreference preferences = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;

    public SuperCSVList(File text, File index, Charset charset) throws IOException {
        super(text, index, charset);
    }

    public SuperCSVList(RandomAccessFileReader reader, RandomAccessFileIndex index, int skipLines) throws IOException {
        super(reader, index);
        this.skipLines = skipLines;
    }

    public void setPreferences(CsvPreference preferences) {
        this.preferences = preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> nextRecord() throws IOException {
        List list;
        CsvListReader parser = null;
        try {
            List values;
            CloseShieldReader theReader = CloseShieldReader.wrap((Reader)this.reader);
            parser = new CsvListReader((Reader)theReader, this.preferences);
            list = values = parser.read();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(parser);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)parser);
        return list;
    }

    public static void main(String[] args) throws Exception {
        new DefaultLibrariesInitializer().fullInitialize();
        String fname = "/home/fdiaz/Descargas/error_union_tablas/Expedientes_CON_REFCAT_trimmed.csv";
        File data_file = new File(fname);
        File index_file = new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + ".idx");
        TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
        taskStatusManager.addObserver((observable, notification) -> {
            TaskStatus status = taskStatusManager.getRunningTaskStatusMostRecent();
        });
        SimpleTaskStatus status = taskStatusManager.createDefaultSimpleTaskStatus(data_file.getName());
        status.add();
        Function<BufferedReader, Integer> numberOfLinesInRecord = breader -> {
            CloseShieldReader theReader = CloseShieldReader.wrap((Reader)breader);
            CsvListReader parser = new CsvListReader((Reader)theReader, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
            try {
                List list = parser.read();
            }
            catch (IOException ex) {
                return 1;
            }
            return parser.getLineNumber();
        };
        RandomAccessFileReader reader = new RandomAccessFileReader(data_file, "UTF-8");
        RandomAccessFileIndex index_lines = reader.createIndexOfLines(index_file, false, RandomAccessFileReader.FILTER_NONE, null, numberOfLinesInRecord);
        SuperCSVList csv = new SuperCSVList(reader, index_lines, 0);
        System.out.println("Lines " + csv.size());
        int n = 0;
        for (List record : csv) {
            if (n < 100) {
                System.out.println(String.format("%6d: %s", n, ArrayUtils.toString((Object)record)));
            } else if (n == 100) {
                System.out.println("More records...");
            }
            ++n;
        }
        System.out.println("-----------------");
        long t1 = new Date().getTime();
        for (int i = csv.size() - 1; i >= 0; --i) {
            List record = (List)csv.get(i);
            if (i < 100) {
                System.out.println(String.format("%6d: %s", i, ArrayUtils.toString((Object)record)));
                continue;
            }
            if (i != 100) continue;
            System.out.println("More records...");
        }
        long t2 = new Date().getTime();
        System.out.println("Time: " + (t2 - t1) + " ms");
        IOUtils.closeQuietly((Closeable)csv);
    }
}

