/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util.content;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.ByteDoubleArrayInputStream;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GlyphOutlineClip;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.InlineImageStreamReference;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.GlyphOutlineDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.content.AbstractContentParser;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.TextMetrics;

public class OContentParser
extends AbstractContentParser {
    private static final Logger logger = Logger.getLogger(OContentParser.class.toString());

    public OContentParser(Library l, Resources r) {
        super(l, r);
    }

    /*
     * Exception decompiling
     */
    public ContentParser parse(byte[][] streamBytes, Page page) throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Shapes parseTextBlocks(byte[][] source) throws UnsupportedEncodingException, InterruptedException {
        Parser parser = new Parser(new ByteDoubleArrayInputStream(source));
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        }
        try {
            Object tok = parser.getStreamObject();
            Stack<Object> stack = new Stack<Object>();
            double yBTstart = 0.0;
            while (tok != null) {
                if (tok instanceof String) {
                    if (tok.equals("BT")) {
                        yBTstart = this.parseText(parser, shapes, yBTstart);
                        stack.clear();
                    } else if (tok.equals("Tf")) {
                        OContentParser.consume_Tf(this.graphicState, stack, this.resources);
                        stack.clear();
                    } else if (tok.equals("Do")) {
                        OContentParser.consume_Do(this.graphicState, stack, shapes, this.resources, false, new AtomicInteger(0), null);
                        stack.clear();
                    }
                } else {
                    stack.push(tok);
                }
                tok = parser.getStreamObject();
            }
            stack.clear();
        }
        catch (IOException e) {
            logger.finer("End of Content Stream");
        }
        shapes.contract();
        return shapes;
    }

    float parseText(Parser parser, Shapes shapes, double previousBTStart) throws IOException, InterruptedException {
        this.inTextBlock = true;
        TextMetrics textMetrics = new TextMetrics();
        this.textBlockBase = new AffineTransform(this.graphicState.getCTM());
        this.graphicState.getTextState().tmatrix = new AffineTransform();
        this.graphicState.getTextState().tlmatrix = new AffineTransform();
        this.graphicState.scale(1.0, -1.0);
        PageText pageText = shapes.getPageText();
        GlyphOutlineClip glyphOutlineClip = new GlyphOutlineClip();
        Object nextToken = parser.getStreamObject();
        while (!nextToken.equals("ET")) {
            if (nextToken instanceof String) {
                if (nextToken.equals("Tj")) {
                    OContentParser.consume_Tj(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                } else if (nextToken.equals("Tc")) {
                    OContentParser.consume_Tc(this.graphicState, this.stack);
                } else if (nextToken.equals("Tw")) {
                    OContentParser.consume_Tw(this.graphicState, this.stack);
                } else if (nextToken.equals("Td")) {
                    OContentParser.consume_Td(this.graphicState, this.stack, textMetrics, pageText, previousBTStart, this.oCGs);
                } else if (nextToken.equals("Tm")) {
                    OContentParser.consume_tm(this.graphicState, this.stack, textMetrics, pageText, previousBTStart, this.textBlockBase, this.oCGs);
                } else if (nextToken.equals("Tf")) {
                    OContentParser.consume_Tf(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("TJ")) {
                    OContentParser.consume_TJ(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                } else if (nextToken.equals("TD")) {
                    OContentParser.consume_TD(this.graphicState, this.stack, textMetrics, pageText, this.oCGs);
                } else if (nextToken.equals("TL")) {
                    OContentParser.consume_TL(this.graphicState, this.stack);
                } else if (nextToken.equals("q")) {
                    this.graphicState = OContentParser.consume_q(this.graphicState);
                } else if (nextToken.equals("Q")) {
                    this.graphicState = this.consume_Q(this.graphicState, shapes);
                } else if (nextToken.equals("cm")) {
                    OContentParser.consume_cm(this.graphicState, this.stack, this.inTextBlock, this.textBlockBase);
                } else if (nextToken.equals("T*")) {
                    OContentParser.consume_T_star(this.graphicState, textMetrics, pageText, this.oCGs);
                } else if (nextToken.equals("BDC")) {
                    OContentParser.consume_BDC(this.stack, shapes, this.oCGs, this.resources);
                } else if (nextToken.equals("EMC")) {
                    OContentParser.consume_EMC(shapes, this.oCGs);
                } else if (nextToken.equals("gs")) {
                    OContentParser.consume_gs(this.graphicState, this.stack, this.resources, shapes);
                } else if (nextToken.equals("w") || nextToken.equals("LW")) {
                    OContentParser.consume_w(this.graphicState, this.stack, shapes, this.glyph2UserSpaceScale);
                } else if (nextToken.equals("sc")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, false);
                } else if (nextToken.equals("scn")) {
                    OContentParser.consume_sc(this.graphicState, this.stack, this.library, this.resources, true);
                } else if (nextToken.equals("k")) {
                    OContentParser.consume_k(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("g")) {
                    OContentParser.consume_g(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("i")) {
                    OContentParser.consume_i(this.stack);
                } else if (nextToken.equals("M")) {
                    OContentParser.consume_M(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("J")) {
                    OContentParser.consume_J(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("rg")) {
                    OContentParser.consume_rg(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("d")) {
                    OContentParser.consume_d(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("j")) {
                    OContentParser.consume_j(this.graphicState, this.stack, shapes);
                } else if (nextToken.equals("cs")) {
                    OContentParser.consume_cs(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("ri")) {
                    OContentParser.consume_ri(this.stack);
                } else if (nextToken.equals("SC")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, false);
                } else if (nextToken.equals("SCN")) {
                    OContentParser.consume_SC(this.graphicState, this.stack, this.library, this.resources, true);
                } else if (nextToken.equals("K")) {
                    OContentParser.consume_K(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("G")) {
                    OContentParser.consume_G(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("RG")) {
                    OContentParser.consume_RG(this.graphicState, this.stack, this.library);
                } else if (nextToken.equals("CS")) {
                    OContentParser.consume_CS(this.graphicState, this.stack, this.resources);
                } else if (nextToken.equals("Tr")) {
                    OContentParser.consume_Tr(this.graphicState, this.stack);
                } else if (nextToken.equals("Tz")) {
                    OContentParser.consume_Tz(this.graphicState, this.stack);
                } else if (nextToken.equals("Ts")) {
                    OContentParser.consume_Ts(this.graphicState, this.stack);
                } else if (!nextToken.equals("BX") && !nextToken.equals("EX")) {
                    if (nextToken.equals("'")) {
                        OContentParser.consume_single_quote(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                    } else if (nextToken.equals("\"")) {
                        OContentParser.consume_double_quote(this.graphicState, this.stack, shapes, textMetrics, glyphOutlineClip, this.oCGs);
                    }
                }
            } else {
                this.stack.push(nextToken);
            }
            nextToken = parser.getStreamObject();
        }
        if (!glyphOutlineClip.isEmpty()) {
            this.graphicState.setClip(glyphOutlineClip.getGlyphOutlineClip());
            shapes.add(new GlyphOutlineDrawCmd(glyphOutlineClip));
        }
        while (!this.stack.isEmpty()) {
            String tmp = this.stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.warning("Text=" + tmp);
        }
        this.graphicState.set(this.textBlockBase);
        this.inTextBlock = false;
        return textMetrics.getyBTStart();
    }

    private void parseInlineImage(Parser p, Shapes shapes) throws IOException {
        try {
            HashMap<Object, Object> iih = new HashMap<Object, Object>();
            Object tok = p.getStreamObject();
            while (!tok.equals("ID")) {
                if (tok.equals("BPC")) {
                    tok = new Name("BitsPerComponent");
                } else if (tok.equals("CS")) {
                    tok = new Name("ColorSpace");
                } else if (tok.equals("D")) {
                    tok = new Name("Decode");
                } else if (tok.equals("DP")) {
                    tok = new Name("DecodeParms");
                } else if (tok.equals("F")) {
                    tok = new Name("Filter");
                } else if (tok.equals("H")) {
                    tok = new Name("Height");
                } else if (tok.equals("IM")) {
                    tok = new Name("ImageMask");
                } else if (tok.equals("I")) {
                    tok = new Name("Indexed");
                } else if (tok.equals("W")) {
                    tok = new Name("Width");
                }
                Object tok1 = p.getStreamObject();
                iih.put(tok, tok1);
                tok = p.getStreamObject();
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
            tok = p.peek2();
            boolean ateEI = false;
            while (tok != null && !tok.equals(" EI") && !(ateEI = p.readLineForInlineImage(buf))) {
                tok = p.peek2();
            }
            if (!ateEI) {
                p.getToken();
            }
            buf.flush();
            buf.close();
            byte[] data = buf.toByteArray();
            ImageStream st = new ImageStream(this.library, iih, data);
            InlineImageStreamReference imageStreamReference = new InlineImageStreamReference(st, this.graphicState, this.resources, 0, null);
            AffineTransform af = new AffineTransform(this.graphicState.getCTM());
            this.graphicState.scale(1.0, -1.0);
            this.graphicState.translate(0.0, -1.0);
            shapes.add(new ImageDrawCmd(imageStreamReference));
            this.graphicState.set(af);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error parsing inline image.", e);
        }
    }
}

