/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.math.regression;

import Jama.Matrix;
import Jama.QRDecomposition;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LeastSquaresFit {
    private final ArrayList m_X = new ArrayList();
    private final ArrayList m_Y = new ArrayList();
    private double[] m_dCoeffs;
    private String m_sExpression;
    private double m_dYMin = Double.MAX_VALUE;
    private double m_dXMax = Double.NEGATIVE_INFINITY;
    private double m_dXMin = Double.MAX_VALUE;
    private double m_dYMax = Double.NEGATIVE_INFINITY;

    public void addValue(double dX, double dY) {
        this.setMinMaxX(dX);
        this.setMinMaxY(dY);
        this.m_X.add(new Double(dX));
        this.m_Y.add(new Double(dY));
    }

    public boolean calculate(int iOrder) {
        Matrix param_matrix;
        int nk = iOrder + 1;
        double[][] alpha = new double[nk][nk];
        double[] beta = new double[nk];
        double term = 0.0;
        this.m_dCoeffs = new double[nk];
        int iNumPoints = this.m_X.size();
        for (int k = 0; k < nk; ++k) {
            double dX;
            for (int j = k; j < nk; ++j) {
                term = 0.0;
                alpha[k][j] = 0.0;
                for (int i = 0; i < iNumPoints; ++i) {
                    double prod1 = 1.0;
                    dX = (Double)this.m_X.get(i);
                    if (k > 0) {
                        for (int m = 0; m < k; ++m) {
                            prod1 *= dX;
                        }
                    }
                    double prod2 = 1.0;
                    if (j > 0) {
                        for (int m = 0; m < j; ++m) {
                            prod2 *= dX;
                        }
                    }
                    term = prod1 * prod2;
                    double[] dArray = alpha[k];
                    int n = j;
                    dArray[n] = dArray[n] + term;
                }
                alpha[j][k] = alpha[k][j];
            }
            for (int i = 0; i < iNumPoints; ++i) {
                dX = (Double)this.m_X.get(i);
                double dY = (Double)this.m_Y.get(i);
                double prod1 = 1.0;
                if (k > 0) {
                    for (int m = 0; m < k; ++m) {
                        prod1 *= dX;
                    }
                }
                term = dY * prod1;
                int n = k;
                beta[n] = beta[n] + term;
            }
        }
        Matrix alpha_matrix = new Matrix(alpha);
        QRDecomposition alpha_QRD = new QRDecomposition(alpha_matrix);
        Matrix beta_matrix = new Matrix(beta, nk);
        try {
            param_matrix = alpha_QRD.solve(beta_matrix);
        }
        catch (Exception e) {
            return false;
        }
        DecimalFormat df = new DecimalFormat("####.#####");
        StringBuffer sb = new StringBuffer("");
        for (int k = 0; k < nk; ++k) {
            this.m_dCoeffs[k] = param_matrix.get(k, 0);
            if (k != 0) {
                sb.append(" + " + df.format(this.m_dCoeffs[k]) + "x^" + Integer.toString(k));
                continue;
            }
            sb.append(df.format(this.m_dCoeffs[k]));
        }
        this.m_sExpression = sb.toString();
        return true;
    }

    public String getExpression() {
        return this.m_sExpression;
    }

    public int getNumPoints() {
        return this.m_X.size();
    }

    public void getPoints(double[] x, double[] y) {
        for (int i = 0; i < this.m_X.size(); ++i) {
            x[i] = (Double)this.m_X.get(i);
            y[i] = (Double)this.m_Y.get(i);
        }
    }

    public double getXMax() {
        return this.m_dXMax;
    }

    public double getXMin() {
        return this.m_dXMin;
    }

    public double getY(double x) {
        double dRet = 0.0;
        for (int i = 0; i < this.m_dCoeffs.length; ++i) {
            dRet += this.m_dCoeffs[i] * Math.pow(x, i);
        }
        return dRet;
    }

    public double getYMax() {
        return this.m_dYMax;
    }

    public double getYMin() {
        return this.m_dYMin;
    }

    private void setMinMaxX(double x) {
        if (x > this.m_dXMax) {
            this.m_dXMax = x;
        }
        if (x < this.m_dXMin) {
            this.m_dXMin = x;
        }
    }

    private void setMinMaxY(double y) {
        if (y > this.m_dYMax) {
            this.m_dYMax = y;
        }
        if (y < this.m_dYMin) {
            this.m_dYMin = y;
        }
    }
}

