/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.math.simpleStats;

public class SimpleStats {
    private double m_dSum = 0.0;
    private double m_dRMS = 0.0;
    private double m_dMean;
    private double m_dVariance;
    private double m_dMax = Double.NEGATIVE_INFINITY;
    private double m_dMin = Double.MAX_VALUE;
    private double m_dStdDev;
    private int m_iCount = 0;
    private double m_dM2 = 0.0;

    public void addValue() {
        ++this.m_iCount;
    }

    public void addValue(double dValue) {
        ++this.m_iCount;
        double dDelta = dValue - this.m_dMean;
        this.m_dMean += dDelta / (double)this.m_iCount;
        this.m_dM2 += dDelta * (dValue - this.m_dMean);
        this.m_dVariance = this.m_dM2 / (double)(this.m_iCount - 1);
        this.m_dSum += dValue;
        this.m_dRMS += dValue * dValue;
        this.m_dMax = Math.max(this.m_dMax, dValue);
        this.m_dMin = Math.min(this.m_dMin, dValue);
        this.m_dStdDev = Math.sqrt(this.m_dVariance);
        this.m_dRMS = Math.sqrt(this.m_dRMS / (double)this.m_iCount);
    }

    public double getCoeffOfVar() {
        return this.m_dVariance / this.m_dMean;
    }

    public int getCount() {
        return this.m_iCount;
    }

    public double getMax() {
        return this.m_dMax;
    }

    public double getMean() {
        return this.m_dMean;
    }

    public double getMin() {
        return this.m_dMin;
    }

    public double getRMS() {
        return this.m_dRMS;
    }

    public double getStdDev() {
        return this.m_dStdDev;
    }

    public double getSum() {
        return this.m_dSum;
    }

    public double getVariance() {
        return this.m_dVariance;
    }
}

