/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.DefaultLayoutManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.utils.XMLEntity;

public class LayoutPage
extends AbstractPreferencePage {
    private static final long serialVersionUID = -8225970409668105935L;
    static String id = LayoutPage.class.getName();
    private ImageIcon icon;
    private JCheckBox chkGridEnabled;
    private JCheckBox chkShowRules;
    private JCheckBox chkShowGrid;
    private JTextField txtVGap;
    private JTextField txtHGap;
    private JCheckBox chkShowInitialPageConfig;
    private JCheckBox chkShowLayoutTOC;
    private JComboBox cbHGapUnit;
    private JComboBox cbVGapUnit;
    private static DefaultLayoutManager layoutManager = null;

    public LayoutPage() {
        int i;
        layoutManager = (DefaultLayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        this.icon = IconThemeHelper.getImageIcon((String)"document-map-icon");
        GridBagLayoutPanel gridRulerPanel = new GridBagLayoutPanel();
        Insets topInsets = new Insets(10, 10, 0, 10);
        Insets insets = new Insets(8, 10, 0, 10);
        Insets lastInsets = new Insets(8, 10, 12, 10);
        gridRulerPanel.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"Grid_and_ruler")));
        this.cbHGapUnit = new JComboBox();
        String[] names = MapContext.getDistanceNames();
        for (i = 0; i < names.length; ++i) {
            this.cbHGapUnit.addItem(PluginServices.getText((Object)((Object)this), (String)names[i]));
        }
        this.txtHGap = new JTextField(5);
        gridRulerPanel.addComponent((Component)new JLabel(PluginServices.getText((Object)((Object)this), (String)"espaciado_horizontal")), (Component)this.txtHGap, (Component)this.cbHGapUnit, 0, insets);
        this.cbVGapUnit = new JComboBox();
        for (i = 0; i < names.length; ++i) {
            this.cbVGapUnit.addItem(PluginServices.getText((Object)((Object)this), (String)names[i]));
        }
        this.txtVGap = new JTextField(5);
        gridRulerPanel.addComponent((Component)new JLabel(PluginServices.getText((Object)((Object)this), (String)"espaciado_vertical")), (Component)this.txtVGap, (Component)this.cbVGapUnit, 0, insets);
        this.chkShowGrid = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"visualizar_cuadricula"));
        gridRulerPanel.addComponent((Component)this.chkShowGrid, insets);
        this.chkGridEnabled = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"malla_activada"));
        gridRulerPanel.addComponent((Component)this.chkGridEnabled, insets);
        this.chkShowRules = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"activar_regla"));
        gridRulerPanel.addComponent((Component)this.chkShowRules, lastInsets);
        this.addComponent((Component)gridRulerPanel, topInsets);
        GridBagLayoutPanel behaviourPanel = new GridBagLayoutPanel();
        behaviourPanel.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"User_interface")));
        this.chkShowInitialPageConfig = new JCheckBox(Messages.getText((String)"Show_page_config_dialog_when_layout_document_is_created"));
        behaviourPanel.addComponent((Component)this.chkShowInitialPageConfig, insets);
        this.chkShowLayoutTOC = new JCheckBox(Messages.getText((String)"Show_table_of_contents_TOC_for_Layout_views"));
        behaviourPanel.addComponent((Component)this.chkShowLayoutTOC, insets);
        this.addComponent((Component)behaviourPanel, lastInsets);
    }

    public void storeValues() throws StoreException {
        boolean showLayoutToc;
        boolean showInitPageConfig;
        boolean showRules;
        boolean showGrid;
        boolean gridEnabled;
        String vGapUnits;
        double vGap;
        String hGapUnits;
        double hGap;
        try {
            hGap = Double.parseDouble(this.txtHGap.getText());
            hGapUnits = MapContext.getDistanceAbbr()[this.cbHGapUnit.getSelectedIndex()];
            vGap = Double.parseDouble(this.txtVGap.getText());
            vGapUnits = MapContext.getDistanceAbbr()[this.cbVGapUnit.getSelectedIndex()];
            gridEnabled = this.chkGridEnabled.isSelected();
            showGrid = this.chkShowGrid.isSelected();
            showRules = this.chkShowRules.isSelected();
            showInitPageConfig = this.chkShowInitialPageConfig.isSelected();
            showLayoutToc = this.chkShowLayoutTOC.isSelected();
        }
        catch (Exception e) {
            throw new StoreException(PluginServices.getText((Object)((Object)this), (String)"invalid_value_for_gap"));
        }
        layoutManager.setDefaultShowGrid(showGrid);
        layoutManager.setDefaultAdjustToGrid(gridEnabled);
        layoutManager.setDefaultShowRulers(showRules);
        Attributes.setDefaultGridGap(hGap, vGap, hGapUnits, vGapUnits);
        PluginServices ps = PluginsLocator.getManager().getPlugin((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        xml.putProperty("DefaultGridHorizontalGap", hGap);
        xml.putProperty("DefaultGridVerticalGap", vGap);
        xml.putProperty("DefaultGridHorizontalGapUnits", hGapUnits);
        xml.putProperty("DefaultGridVerticalGapUnits", vGapUnits);
        xml.putProperty("DefaultShowLayoutGrid", showGrid);
        xml.putProperty("DefaultEnableLayoutGrid", gridEnabled);
        xml.putProperty("DefaultShowLayoutRules", showRules);
        xml.putProperty("DefaulShowInitialPageConfigLayout", showInitPageConfig);
        xml.putProperty("DefaultShowLayoutToc", showLayoutToc);
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"Mapa");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        PluginServices ps = PluginsLocator.getManager().getPlugin((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        double hGap = 1.0;
        double vGap = 1.0;
        boolean showGrid = true;
        boolean gridEnabled = false;
        boolean showRules = true;
        boolean showInitPageConfig = true;
        boolean showLayoutToc = true;
        if (xml.contains("DefaultGridHorizontalGap")) {
            hGap = xml.getDoubleProperty("DefaultGridHorizontalGap");
        }
        this.txtHGap.setText(String.valueOf(hGap));
        if (xml.contains("DefaultGridVerticalGap")) {
            vGap = xml.getDoubleProperty("DefaultGridVerticalGap");
        }
        this.txtVGap.setText(String.valueOf(vGap));
        String hGapUnit = xml.contains("DefaultGridHorizontalGapUnits") ? xml.getStringProperty("DefaultGridHorizontalGapUnits") : "cm";
        this.cbHGapUnit.setSelectedIndex(Attributes.getDistanceAbbrPosition(hGapUnit));
        String vGapUnit = xml.contains("DefaultGridVerticalGapUnits") ? xml.getStringProperty("DefaultGridVerticalGapUnits") : "cm";
        this.cbVGapUnit.setSelectedIndex(Attributes.getDistanceAbbrPosition(vGapUnit));
        if (xml.contains("DefaultShowLayoutGrid")) {
            showGrid = xml.getBooleanProperty("DefaultShowLayoutGrid");
        }
        this.chkShowGrid.setSelected(showGrid);
        if (xml.contains("DefaultEnableLayoutGrid")) {
            gridEnabled = xml.getBooleanProperty("DefaultEnableLayoutGrid");
        }
        this.chkGridEnabled.setSelected(gridEnabled);
        if (xml.contains("DefaultShowLayoutRules")) {
            showRules = xml.getBooleanProperty("DefaultShowLayoutRules");
        }
        this.chkShowRules.setSelected(showRules);
        if (xml.contains("DefaulShowInitialPageConfigLayout")) {
            showInitPageConfig = xml.getBooleanProperty("DefaulShowInitialPageConfigLayout");
        }
        this.chkShowInitialPageConfig.setSelected(showInitPageConfig);
        if (xml.contains("DefaultShowLayoutToc")) {
            showLayoutToc = xml.getBooleanProperty("DefaultShowLayoutToc");
        }
        this.chkShowLayoutTOC.setSelected(showLayoutToc);
        layoutManager.setDefaultShowGrid(showGrid);
        layoutManager.setDefaultAdjustToGrid(gridEnabled);
        layoutManager.setDefaultShowRulers(showRules);
        Attributes.setDefaultGridGap(hGap, vGap, hGapUnit, vGapUnit);
    }

    public void initializeDefaults() {
        this.txtHGap.setText(String.valueOf(1.0));
        this.txtVGap.setText(String.valueOf(1.0));
        this.cbHGapUnit.setSelectedIndex(Attributes.getDistanceAbbrPosition("cm"));
        this.cbVGapUnit.setSelectedIndex(Attributes.getDistanceAbbrPosition("cm"));
        this.chkShowGrid.setSelected(true);
        this.chkGridEnabled.setSelected(false);
        this.chkShowRules.setSelected(true);
        this.chkShowInitialPageConfig.setSelected(true);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }
}

