/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayoutDraw
implements Observable,
Printable {
    private static final Logger LOG = LoggerFactory.getLogger(FLayoutDraw.class);
    private LayoutPanel layoutPanel;
    private LayoutControl layoutControl;
    private LayoutContext layoutContext;
    private ObservableHelper observers;

    public FLayoutDraw(LayoutPanel layoutPanel) {
        this.layoutPanel = layoutPanel;
        this.observers = new ObservableHelper();
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
    }

    public void initialize() {
        if (this.layoutContext == null || this.layoutControl == null) {
            this.layoutControl = this.layoutPanel.getLayoutControl();
            this.layoutContext = this.layoutPanel.getLayoutContext();
        }
    }

    public void drawLayout(Graphics2D g2, BufferedImage imgBase) {
        IFFrame[] fframes;
        if (!this.initializeAffineTransform()) {
            return;
        }
        for (IFFrame f : fframes = this.layoutContext.getFFrames()) {
            f.draw(g2, this.layoutContext.getAT(), this.layoutControl.getComponent().getVisibleRect(), imgBase);
            if (f.getTag() == null || !this.layoutPanel.isShowIconTag()) continue;
            f.drawSymbolTag(g2);
        }
        if (fframes.length != 0) {
            this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_validated"));
        } else {
            this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_invalidated"));
        }
    }

    public boolean initializeAffineTransform() {
        this.initialize();
        AffineTransform at = this.layoutContext.getAT();
        Rectangle2D.Double rLayout = this.layoutControl.getRect();
        if (((RectangularShape)rLayout).getHeight() < 0.0) {
            return false;
        }
        Attributes attributes = this.layoutContext.getAttributes();
        this.layoutControl.setCancelDrawing(false);
        double scale = ((RectangularShape)rLayout).getHeight() / attributes.getPaperSize().getHeight() * 1.0;
        AffineTransform escalado = new AffineTransform();
        AffineTransform translacion = new AffineTransform();
        translacion.setToTranslation(rLayout.getMinX(), rLayout.getMinY());
        escalado.setToScale(scale, scale);
        at.setToIdentity();
        at.concatenate(translacion);
        at.concatenate(escalado);
        attributes.calculateGridGapX(rLayout);
        attributes.calculateGridGapY(rLayout);
        return true;
    }

    public void drawRectangle(Graphics2D g) {
        this.initialize();
        Attributes attributes = this.layoutContext.getAttributes();
        Rectangle2D.Double rLayout = this.layoutControl.getRect();
        AffineTransform at = this.layoutContext.getAT();
        double unidadesX = attributes.getHGridGapCm();
        double unidadesY = attributes.getVGridGapCm();
        if (unidadesX == 0.0 && unidadesY == 0.0) {
            return;
        }
        g.setColor(Color.darkGray);
        Rectangle2D.Double rectBig = new Rectangle2D.Double(((RectangularShape)rLayout).getX(), ((RectangularShape)rLayout).getY(), ((RectangularShape)rLayout).getWidth(), ((RectangularShape)rLayout).getHeight());
        g.fillRect((int)rectBig.x + 7, (int)rectBig.y + 7, (int)rectBig.width, (int)rectBig.height);
        Rectangle2D.Double r = new Rectangle2D.Double();
        if (attributes.isMargin()) {
            r = new Rectangle2D.Double(((RectangularShape)rLayout).getX() + FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[2], at), ((RectangularShape)rLayout).getY() + FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[0], at), ((RectangularShape)rLayout).getWidth() - FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[2] + attributes.getAreaInsets()[3], at), ((RectangularShape)rLayout).getHeight() - FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[0] + attributes.getAreaInsets()[1], at));
        } else {
            r.setRect(rLayout);
        }
        g.setColor(Color.white);
        g.fill(rLayout);
        g.setColor(Color.darkGray);
        g.drawRect((int)rLayout.getMinX(), (int)rLayout.getMinY(), (int)((RectangularShape)rLayout).getWidth(), (int)((RectangularShape)rLayout).getHeight());
        if (attributes.isMargin()) {
            g.setColor(Color.black);
            g.drawRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
        }
    }

    public void drawGrid(Graphics2D g) {
        int unidadesMin = 6;
        Attributes attributes = this.layoutContext.getAttributes();
        Rectangle2D.Double rLayout = this.layoutControl.getRect();
        AffineTransform at = this.layoutContext.getAT();
        double unidadesX = attributes.getHGridGapPx();
        double unidadesY = attributes.getVGridGapPx();
        Rectangle2D.Double r = new Rectangle2D.Double();
        if (attributes.isMargin()) {
            r = new Rectangle2D.Double(((RectangularShape)rLayout).getX() + FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[2], at), ((RectangularShape)rLayout).getY() + FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[0], at), ((RectangularShape)rLayout).getWidth() - FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[2] + attributes.getAreaInsets()[3], at), ((RectangularShape)rLayout).getHeight() - FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[0] + attributes.getAreaInsets()[1], at));
        } else {
            r.setRect(rLayout);
        }
        if (unidadesX == 0.0 && unidadesY == 0.0) {
            return;
        }
        g.setColor(Color.darkGray);
        if ((unidadesX > (double)unidadesMin || unidadesY > (double)unidadesMin) && this.layoutContext.isGridVisible()) {
            for (double ax = r.getMinX(); ax < r.getMaxX(); ax += unidadesX) {
                for (double ay = r.getMinY(); ay < r.getMaxY(); ay += unidadesY) {
                    g.drawLine((int)ax, (int)ay, (int)ax, (int)ay);
                }
            }
        }
    }

    public void drawRuler(Graphics2D g, Color color) {
        Attributes attributes = this.layoutContext.getAttributes();
        Rectangle2D.Double rLayout = this.layoutControl.getRect();
        AffineTransform at = this.layoutContext.getAT();
        if (this.layoutContext.getRuler()) {
            int ini = 10;
            int w = 30;
            int wi = 16;
            g.setColor(new Color(250, 255, 250, 180));
            g.fillRect(ini, w, wi, this.layoutControl.getComponent().getHeight() - w);
            g.fillRect(w, ini, this.layoutControl.getWidth() - w, wi);
            g.setColor(new Color(100, 155, 150, 180));
            g.fillRect(w, ini, (int)((RectangularShape)rLayout).getX() - w, wi);
            g.fillRect((int)rLayout.getMaxX(), ini, this.layoutControl.getWidth() - (int)rLayout.getMaxX(), wi);
            g.fillRect(ini, w, wi, (int)((RectangularShape)rLayout).getY() - w);
            g.fillRect(ini, (int)rLayout.getMaxY(), wi, this.layoutControl.getHeight() - (int)rLayout.getMaxY());
            if (attributes.isMargin()) {
                g.setColor(new Color(50, 55, 50, 180));
                g.fillRect((int)((RectangularShape)rLayout).getX(), ini, (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[2], at), wi);
                g.fillRect((int)rLayout.getMaxX() - (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[3], at), ini, (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[3], at), wi);
                g.fillRect(ini, (int)((RectangularShape)rLayout).getY(), wi, (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[0], at));
                g.fillRect(ini, (int)rLayout.getMaxY() - (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[1], at), wi, (int)FLayoutUtilities.fromSheetDistance(attributes.getAreaInsets()[1], at));
            }
            g.setColor(color);
            g.drawLine(w, wi + ini, this.layoutControl.getWidth(), wi + ini);
            g.drawLine(w, ini, this.layoutControl.getWidth(), ini);
            g.drawLine(ini, w, ini, this.layoutControl.getHeight());
            g.drawLine(wi + ini, w, wi + ini, this.layoutControl.getHeight());
            this.drawLineY(g, 5.0, 12, 22, ((RectangularShape)rLayout).getY(), 0.0);
            this.drawLineX(g, 5.0, 12, 22, ((RectangularShape)rLayout).getX(), 0.0);
            if (FLayoutUtilities.fromSheetDistance(1.0, at) > 15.0) {
                this.drawLineY(g, 1.0, 12, 22, ((RectangularShape)rLayout).getY(), 0.0);
                this.drawLineX(g, 1.0, 12, 22, ((RectangularShape)rLayout).getX(), 0.0);
                if (FLayoutUtilities.fromSheetDistance(1.0, at) > 25.0) {
                    this.drawLineY(g, 1.0, 18, 22, ((RectangularShape)rLayout).getY(), 0.5);
                    this.drawLineY(g, 0.1, 21, 22, ((RectangularShape)rLayout).getY(), 0.0);
                    this.drawLineX(g, 1.0, 18, 22, ((RectangularShape)rLayout).getX(), 0.5);
                    this.drawLineX(g, 0.1, 21, 22, ((RectangularShape)rLayout).getX(), 0.0);
                }
            }
        }
    }

    private void drawLineY(Graphics2D g, double dist, int init, int end, double y, double desp) {
        this.initialize();
        AffineTransform at = this.layoutContext.getAT();
        double distY = FLayoutUtilities.fromSheetDistance(dist, at);
        double rota = Math.toRadians(90.0);
        if (distY > 4.0) {
            double posUnitY;
            double despY = FLayoutUtilities.fromSheetDistance(desp, at);
            double posUnitYNeg = posUnitY = y + despY;
            int num = 0;
            double iniY = 40.0;
            Point2D.Double pfin = FLayoutUtilities.fromSheetPoint(new Point2D.Double(this.layoutControl.getWidth(), this.layoutControl.getHeight()), at);
            while (posUnitY < pfin.y - 5.0) {
                posUnitYNeg -= distY;
                if (distY > 16.0 && init == 12) {
                    if (posUnitY > iniY) {
                        g.rotate(-rota, 20.0, posUnitY - 12.0);
                        g.drawString(String.valueOf(num), 10, (int)posUnitY - 12);
                        g.rotate(rota, 20.0, posUnitY - 12.0);
                    }
                    num = dist == 5.0 ? (num += 5) : ++num;
                    if (posUnitYNeg > iniY) {
                        g.rotate(-rota, 20.0, posUnitYNeg - 12.0);
                        g.drawString(String.valueOf(-num), 10, (int)posUnitYNeg - 12);
                        g.rotate(rota, 20.0, posUnitYNeg - 12.0);
                    }
                }
                if (posUnitY > iniY) {
                    g.drawLine(2 + init, (int)posUnitY, 2 + end, (int)posUnitY);
                }
                if (posUnitYNeg > iniY) {
                    g.drawLine(2 + init, (int)posUnitYNeg, 2 + end, (int)posUnitYNeg);
                }
                posUnitY += distY;
            }
        }
    }

    private void drawLineX(Graphics2D g, double dist, int init, int end, double x, double desp) {
        this.initialize();
        AffineTransform at = this.layoutContext.getAT();
        double distX = FLayoutUtilities.fromSheetDistance(dist, at);
        if (distX > 4.0) {
            double posUnitX;
            double despX = FLayoutUtilities.fromSheetDistance(desp, at);
            double posUnitXNeg = posUnitX = x + despX;
            int num = 0;
            double iniX = 40.0;
            Point2D.Double pfin = FLayoutUtilities.fromSheetPoint(new Point2D.Double(this.layoutControl.getWidth(), this.layoutControl.getHeight()), at);
            while (posUnitX < pfin.x - 5.0) {
                posUnitXNeg -= distX;
                if (init == 12 && distX > 16.0) {
                    if (posUnitX > iniX) {
                        g.drawString(String.valueOf(num), (int)posUnitX + 3, 20);
                    }
                    num = dist == 5.0 ? (num += 5) : ++num;
                    if (posUnitXNeg > iniX) {
                        g.drawString(String.valueOf(-num), (int)posUnitXNeg + 3, 20);
                    }
                }
                if (posUnitX > iniX) {
                    g.drawLine((int)posUnitX, 2 + init, (int)posUnitX, 2 + end);
                }
                if (posUnitXNeg > iniX) {
                    g.drawLine((int)posUnitXNeg, 2 + init, (int)posUnitXNeg, 2 + end);
                }
                posUnitX += distX;
            }
        }
    }

    public void drawHandlers(Graphics2D g, Color color) {
        IFFrame[] fframes;
        this.initialize();
        g.setColor(color);
        for (IFFrame fframe : fframes = this.layoutContext.getFFrames()) {
            if (fframe.getSelected() == 0) continue;
            fframe.drawHandlers(g);
        }
    }

    public void toPS(File ps) {
        this.initialize();
        Attributes attributes = this.layoutContext.getAttributes();
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(ps));
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, "application/postscript");
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(fos);
                DocPrintJob job = service.createPrintJob();
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintRequestAttributeSet att = attributes.toPrintRequestAttributeSet();
                job.print(doc, att);
            }
            ((OutputStream)fos).close();
        }
        catch (IOException | PrintException e) {
            LOG.error("Error printing the map", (Throwable)e);
        }
        this.layoutControl.fullRect();
    }

    public void toPDF(File pdf) {
        Attributes attributes = this.layoutContext.getAttributes();
        double w = attributes.getPaperSize().getWidth() * (double)Attributes.DPISCREEN / 2.54;
        double h = attributes.getPaperSize().getHeight() * (double)Attributes.DPISCREEN / 2.54;
        Rectangle pageSize = new Rectangle((float)w, (float)h);
        Document document = new Document(pageSize);
        try {
            FileOutputStream fos = new FileOutputStream(pdf);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g2 = cb.createGraphicsShapes((float)w, (float)h);
            try {
                this.print(g2, new PageFormat(), 0);
            }
            catch (PrinterException e) {
                LOG.error("Error printing the map", (Throwable)e);
            }
            g2.dispose();
        }
        catch (DocumentException de) {
            LOG.error("Error printing the map", (Throwable)de);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), ioe.getMessage());
        }
        document.close();
        this.layoutControl.fullRect();
    }

    @Override
    public int print(Graphics g, PageFormat format, int pi) throws PrinterException {
        this.initialize();
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        g2d.translate(0, 0);
        this.layoutPanel.obtainRect(true);
        g2d.scale(72.0 / (double)Attributes.DPI, 72.0 / (double)Attributes.DPI);
        if (this.layoutContext.getAttributes().isMargin()) {
            g2d.setClip((int)(this.layoutControl.getRect().getMinX() + FLayoutUtilities.fromSheetDistance(this.layoutContext.getAttributes().getAreaInsets()[2], this.layoutControl.getAT())), (int)(this.layoutPanel.getLayoutControl().getRect().getMinY() + FLayoutUtilities.fromSheetDistance(this.layoutContext.getAttributes().getAreaInsets()[0], this.layoutControl.getAT())), (int)(this.layoutControl.getRect().getWidth() - FLayoutUtilities.fromSheetDistance(this.layoutContext.getAttributes().getAreaInsets()[2] + this.layoutContext.getAttributes().getAreaInsets()[3], this.layoutControl.getAT())), (int)(this.layoutPanel.getLayoutControl().getRect().getHeight() - FLayoutUtilities.fromSheetDistance(this.layoutContext.getAttributes().getAreaInsets()[0] + this.layoutContext.getAttributes().getAreaInsets()[1], this.layoutControl.getAT())));
        }
        this.drawShapes(g2d);
        g2d.setTransform(at);
        return 0;
    }

    public void drawShapes(Graphics2D g2) {
        IFFrame[] fframes;
        this.initialize();
        this.layoutPanel.setCursor(Cursor.getDefaultCursor());
        if (!this.initializeAffineTransform()) {
            return;
        }
        for (IFFrame fframe : fframes = this.layoutContext.getFFrames()) {
            fframe.print(g2, this.layoutControl.getAT(), null, this.layoutContext.getAttributes().toPrintAttributes());
        }
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }
}

