/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.gvsig.app.project.documents.layout.gui.FPopupMenu;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.utils.exceptionHandling.ExceptionHandlingSupport;
import org.gvsig.utils.exceptionHandling.ExceptionListener;

public class LayoutEvents
implements ActionListener,
ComponentListener,
MouseMotionListener,
MouseListener {
    private LayoutPanel layout = null;
    private ExceptionHandlingSupport exceptionHandlingSupport = new ExceptionHandlingSupport();

    public LayoutEvents(LayoutPanel l) {
        this.layout = l;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.layout.getLayoutControl().refresh();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.layout.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getButton() != 3) {
            this.layout.getLayoutControl().setLastPoint();
            this.layout.repaint();
        }
        try {
            this.layout.getLayoutControl().getCurrentLayoutTool().mouseDragged(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
        this.layout.getLayoutControl().setPosition(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.layout.getLayoutControl().setPosition(e.getPoint());
        try {
            this.layout.getLayoutControl().getCurrentLayoutTool().mouseMoved(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
        this.layout.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            this.layout.getLayoutControl().getComponent().requestFocusInWindow();
            this.layout.getLayoutControl().getCurrentLayoutTool().mouseClicked(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
    }

    public void addExceptionListener(ExceptionListener o) {
        this.exceptionHandlingSupport.addExceptionListener(o);
    }

    public boolean removeExceptionListener(ExceptionListener o) {
        return this.exceptionHandlingSupport.removeExceptionListener(o);
    }

    protected void throwException(Throwable t) {
        this.exceptionHandlingSupport.throwException(t);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.layout.getLayoutControl().clearMouseImage();
        try {
            this.layout.getLayoutControl().getCurrentLayoutTool().mouseEntered(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        try {
            this.layout.getLayoutControl().getCurrentLayoutTool().mouseExited(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.layout.getLayoutControl().setPointAnt();
            this.layout.getLayoutControl().setFirstPoint();
            try {
                this.layout.getLayoutControl().getCurrentLayoutTool().mousePressed(e);
            }
            catch (BehaviorException t) {
                this.throwException(t);
            }
        } else if (e.getButton() == 3) {
            FPopupMenu popmenu = new FPopupMenu(this.layout);
            this.layout.add(popmenu);
            popmenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 3) {
            this.layout.getLayoutControl().setLastPoint();
        }
        if (e.getButton() == 1) {
            try {
                this.layout.getLayoutControl().getCurrentLayoutTool().mouseReleased(e);
            }
            catch (BehaviorException t) {
                this.throwException(t);
            }
            this.layout.getLayoutControl().setCancelDrawing(false);
        } else if (e.getButton() == 3) {
            // empty if block
        }
    }
}

