/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.view.toc.DnDJTree;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;

public class LayoutKeyEvent
implements KeyEventDispatcher {
    private static IFFrame[] selectFFrames = new IFFrame[0];
    private int difX;
    private int difY;

    public static boolean copy(LayoutPanel layout) throws CloneNotSupportedException {
        IFFrame[] fframes = layout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return false;
        }
        selectFFrames = new IFFrame[fframes.length];
        for (int i = 0; i < fframes.length; ++i) {
            LayoutKeyEvent.selectFFrames[i] = (IFFrame)fframes[i].clone();
        }
        return true;
    }

    public static boolean cut(LayoutPanel layout) throws CloneNotSupportedException {
        IFFrame[] fframes = layout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return false;
        }
        selectFFrames = new IFFrame[fframes.length];
        for (int i = 0; i < fframes.length; ++i) {
            LayoutKeyEvent.selectFFrames[i] = (IFFrame)fframes[i].clone();
        }
        layout.getLayoutContext().delFFrameSelected();
        layout.getLayoutContext().notifAllObservers();
        return true;
    }

    public static boolean paste(LayoutPanel layout) throws CloneNotSupportedException {
        IFFrame copyFFrame = null;
        layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)layout, (String)"paste_elements"));
        for (int i = 0; i < selectFFrames.length; ++i) {
            copyFFrame = (IFFrame)selectFFrames[i].clone();
            if (i == 0) {
                layout.getLayoutContext().addFFrame(copyFFrame, true, true);
            } else {
                layout.getLayoutContext().addFFrame(copyFFrame, false, true);
            }
            copyFFrame.setDocument(layout.getDocument());
        }
        layout.getLayoutContext().getFrameCommandsRecord().endComplex();
        layout.getLayoutContext().notifAllObservers();
        return true;
    }

    public static boolean undo(LayoutPanel layout) {
        LayoutContext lcontext = layout.getLayoutContext();
        try {
            lcontext.getFrameCommandsRecord().undo();
        }
        catch (UndoException e) {
            e.printStackTrace();
        }
        layout.getLayoutContext().updateFFrames();
        layout.getLayoutContext().notifAllObservers();
        PluginServices.getMainFrame().enableControls();
        return true;
    }

    public static boolean redo(LayoutPanel layout) {
        LayoutContext lcontext = layout.getLayoutContext();
        try {
            lcontext.getFrameCommandsRecord().redo();
        }
        catch (RedoException e) {
            e.printStackTrace();
        }
        lcontext.updateFFrames();
        layout.getLayoutContext().notifAllObservers();
        PluginServices.getMainFrame().enableControls();
        return true;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        IWindow view = PluginServices.getMDIManager().getActiveWindow();
        try {
            if (e.getID() == 401 || !(view instanceof LayoutPanel) || !(e.getSource() instanceof LayoutControl) && !(e.getSource() instanceof DnDJTree)) {
                return false;
            }
            LayoutPanel layout = (LayoutPanel)view;
            if (!layout.getLayoutContext().isEditable()) {
                return false;
            }
            IFFrame[] fframes = layout.getLayoutContext().getSelectedFFrames();
            int dif = 10;
            if (e.getModifiers() == 2) {
                switch (e.getKeyCode()) {
                    case 67: {
                        LayoutKeyEvent.copy(layout);
                        break;
                    }
                    case 88: {
                        LayoutKeyEvent.cut(layout);
                        break;
                    }
                    case 86: {
                        LayoutKeyEvent.paste(layout);
                        break;
                    }
                    case 90: {
                        LayoutKeyEvent.undo(layout);
                        break;
                    }
                    case 89: {
                        LayoutKeyEvent.redo(layout);
                    }
                }
            } else {
                switch (e.getKeyCode()) {
                    case 37: {
                        this.difX -= dif;
                        break;
                    }
                    case 39: {
                        this.difX += dif;
                        break;
                    }
                    case 38: {
                        this.difY -= dif;
                        break;
                    }
                    case 40: {
                        this.difY += dif;
                        break;
                    }
                    case 8: 
                    case 127: {
                        layout.getLayoutContext().delFFrameSelected();
                        layout.getLayoutControl().refresh();
                    }
                }
                if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    if (fframes.length == 0) {
                        return false;
                    }
                    layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"move_elements"));
                    for (int i = 0; i < fframes.length; ++i) {
                        IFFrame fframeAux = (IFFrame)fframes[i].clone();
                        Rectangle2D r = this.getRectMove(fframes[i].getBoundingBox(layout.getLayoutControl().getAT()), this.difX, this.difY);
                        fframeAux.setBoundBox(FLayoutUtilities.toSheetRect(r, layout.getLayoutControl().getAT()));
                        layout.getLayoutContext().getFrameCommandsRecord().update(fframes[i], fframeAux);
                    }
                    layout.getLayoutContext().getFrameCommandsRecord().endComplex();
                    layout.getLayoutContext().updateFFrames();
                    layout.getLayoutControl().refresh();
                }
                this.difX = 0;
                this.difY = 0;
            }
            return true;
        }
        catch (CloneNotSupportedException e1) {
            NotificationManager.addError((Throwable)e1);
            return false;
        }
    }

    private Rectangle2D getRectMove(Rectangle2D r, int difX, int difY) {
        Rectangle2D.Double rectMove = new Rectangle2D.Double();
        ((Rectangle2D)rectMove).setRect(r.getX() + (double)difX, r.getY() + (double)difY, r.getWidth(), r.getHeight());
        return rectMove;
    }

    public static boolean hasSelection() {
        return selectFFrames.length > 0;
    }
}

