/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui.numberFormat;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import org.gvsig.i18n.Messages;

public class CharComboBox
extends JComboBox {
    private static final long serialVersionUID = 2194202669931887456L;
    private String noneItem = Messages.getText((String)"None");

    public CharComboBox(String[] items, boolean showNoneItem) {
        this.setEditable(true);
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (item == null || item.length() <= 0) continue;
            this.addItem(new String(item.substring(0, 1)));
        }
        if (showNoneItem) {
            this.addItem(this.noneItem);
        }
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String item = CharComboBox.this.getSelectedItem();
                if (item != null) {
                    CharComboBox.this.setSelectedItem(item);
                }
            }
        });
    }

    public CharComboBox() {
        this(new String[]{" "}, true);
    }

    @Override
    public String getSelectedItem() {
        String item = (String)super.getSelectedItem();
        if (item != null && item != this.noneItem) {
            if (item.length() > 0) {
                return item.substring(0, 1);
            }
            return " ";
        }
        return this.noneItem;
    }

    public void addItem(Object obj) {
        super.addItem(String.valueOf(obj));
    }

    public void setNoneItem(String text) {
        this.removeItem(this.noneItem);
        this.noneItem = text;
        this.addItem(text);
    }

    public String getNoneItem() {
        return this.noneItem;
    }
}

