/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.geometryadapters;

import java.awt.geom.Point2D;
import org.gvsig.app.project.documents.layout.geometryadapters.PolygonAdapter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangleAdapter
extends PolygonAdapter {
    public static final String PERSISTENCE_DEFINITION_NAME = "RectangleAdapter";
    private static final Logger logger = LoggerFactory.getLogger(RectangleAdapter.class);

    @Override
    public void obtainShape(Point2D p) {
        Point2D[] points = this.getPoints();
        try {
            Surface surface = (Surface)geomManager.create(3, 0);
            if (points.length > 0) {
                surface.addVertex(geomManager.createPoint(points[0].getX(), points[0].getY(), 0));
                surface.addVertex(geomManager.createPoint(p.getX(), points[0].getY(), 0));
                surface.addVertex(geomManager.createPoint(p.getX(), p.getY(), 0));
                surface.addVertex(geomManager.createPoint(points[0].getX(), p.getY(), 0));
                surface.addVertex(geomManager.createPoint(points[0].getX(), points[0].getY(), 0));
            }
            this.setGeometry((Geometry)surface);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the circle", (Throwable)e);
        }
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(RectangleAdapter.class, PERSISTENCE_DEFINITION_NAME, "Recangle Adapter persistence definition", null, null);
            definition.extend(manager.getDefinition("GeometryAdapter"));
        }
    }
}

