/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.view.IContextMenuAction;

public class FPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 5340224239252101704L;
    protected LayoutPanel layout;
    private IFFrame[] selecteds;
    public static final Font theFont = new Font("SansSerif", 0, 10);

    public FPopupMenu(LayoutPanel layout) {
        this.initialize(layout);
    }

    private void initialize(LayoutPanel layout) {
        this.layout = layout;
        this.selecteds = this.layout.getLayoutContext().getSelectedFFrames();
        LayoutManager layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        IContextMenuAction[] actions = layoutManager.createLayoutMenuActions(layout);
        this.createMenuElements(actions);
    }

    private void createMenuElements(IContextMenuAction[] actions) {
        String group = null;
        for (int i = 0; i < actions.length; ++i) {
            IContextMenuAction action = actions[i];
            MenuItem item = new MenuItem(action.getText(), action);
            item.setFont(theFont);
            item.setEnabled(action.isEnabled(null, (Object[])this.selecteds));
            if (!action.getGroup().equals(group)) {
                if (group != null) {
                    this.addSeparator();
                }
                group = action.getGroup();
            }
            this.add(item);
        }
    }

    public class MenuItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 2518112362194914446L;
        private IContextMenuAction action;

        public MenuItem(String text, IContextMenuAction documentAction) {
            super(text);
            this.action = documentAction;
            String tip = this.action.getDescription();
            if (tip != null && tip.length() > 0) {
                this.setToolTipText(tip);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.execute((Object)FPopupMenu.this.layout.getLayoutContext(), (Object[])FPopupMenu.this.selecteds);
        }
    }
}

