/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPositionDialog
extends JPanel
implements IWindow,
Observable {
    private static final long serialVersionUID = -1289724614739172740L;
    protected static final Logger LOG = LoggerFactory.getLogger(FPositionDialog.class);
    private JLabel lDesdeIzquierda = null;
    private JLabel lDesdeArriba = null;
    private JLabel lAnchura = null;
    private JLabel lAltura = null;
    private JButton bAceptar = null;
    private JButton bCancelar = null;
    private JTextField tDesdeIzquierda = null;
    private JTextField tDesdeDerecha = null;
    private JTextField tAnchura = null;
    private JTextField tAltura = null;
    private JLabel lNomUnidades = null;
    private JLabel lUnidades = null;
    private LayoutPanel layout = null;
    private String m_NameUnit = null;
    NumberFormat nf = NumberFormat.getInstance();
    private JLabel lAnchoUnidades = null;
    private JLabel lAlto = null;
    private JLabel lAltoUnidades = null;
    private JLabel lAncho = null;
    private JPanel pFolio = null;
    private JLabel lSeparador = null;
    private IFFrame fframe;
    private ObservableHelper observers;

    public FPositionDialog(LayoutPanel layoutPanel, IFFrame fframe) {
        this.layout = layoutPanel;
        this.fframe = fframe;
        this.observers = new ObservableHelper();
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        if (this.layout.getLayoutContext().isAdjustingToGrid()) {
            this.nf.setMaximumFractionDigits(1);
        } else {
            this.nf.setMaximumFractionDigits(2);
        }
        this.m_NameUnit = this.layout.getLayoutContext().getAttributes().getNameUnit();
        this.add((Component)this.getLDesdeIzquierda(), null);
        this.add((Component)this.getLDesdeArriba(), null);
        this.add((Component)this.getLAnchura(), null);
        this.add((Component)this.getLAltura(), null);
        this.add((Component)this.getBAceptar(), null);
        this.add((Component)this.getBCancelar(), null);
        this.add((Component)this.getTDesdeIzquierda(), null);
        this.add((Component)this.getTDesdeDerecha(), null);
        this.add((Component)this.getTAnchura(), null);
        this.add((Component)this.getTAltura(), null);
        this.add((Component)this.getLNomUnidades(), null);
        this.add((Component)this.getLUnidades(), null);
        this.add((Component)this.getPFolio(), null);
        this.setSize(203, 215);
    }

    private JLabel getLDesdeIzquierda() {
        if (this.lDesdeIzquierda == null) {
            this.lDesdeIzquierda = new JLabel();
            this.lDesdeIzquierda.setBounds(9, 85, 116, 20);
            this.lDesdeIzquierda.setText(PluginServices.getText((Object)this, (String)"desde_izquierda"));
        }
        return this.lDesdeIzquierda;
    }

    private JLabel getLDesdeArriba() {
        if (this.lDesdeArriba == null) {
            this.lDesdeArriba = new JLabel();
            this.lDesdeArriba.setBounds(9, 110, 116, 20);
            this.lDesdeArriba.setText(PluginServices.getText((Object)this, (String)"desde_arriba"));
        }
        return this.lDesdeArriba;
    }

    private JLabel getLAnchura() {
        if (this.lAnchura == null) {
            this.lAnchura = new JLabel();
            this.lAnchura.setBounds(9, 135, 116, 20);
            this.lAnchura.setText(PluginServices.getText((Object)this, (String)"anchura"));
        }
        return this.lAnchura;
    }

    private JLabel getLAltura() {
        if (this.lAltura == null) {
            this.lAltura = new JLabel();
            this.lAltura.setBounds(9, 160, 116, 20);
            this.lAltura.setText(PluginServices.getText((Object)this, (String)"altura"));
        }
        return this.lAltura;
    }

    private JButton getBAceptar() {
        if (this.bAceptar == null) {
            this.bAceptar = new JButton();
            this.bAceptar.setBounds(12, 185, 85, 23);
            this.bAceptar.setText(PluginServices.getText((Object)this, (String)"Aceptar"));
            this.bAceptar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Rectangle2D.Double r = new Rectangle2D.Double();
                    if (FPositionDialog.this.getTDesdeIzquierda().getText().equals("")) {
                        FPositionDialog.this.getTDesdeIzquierda().setText("0");
                    }
                    if (FPositionDialog.this.getTDesdeDerecha().getText().equals("")) {
                        FPositionDialog.this.getTDesdeDerecha().setText("0");
                    }
                    if (FPositionDialog.this.getTAnchura().getText().equals("")) {
                        FPositionDialog.this.getTAnchura().setText("0");
                    }
                    if (FPositionDialog.this.getTAltura().getText().equals("")) {
                        FPositionDialog.this.getTAltura().setText("0");
                    }
                    r.x = FPositionDialog.this.stringToDouble(FPositionDialog.this.getTDesdeIzquierda().getText().toString());
                    r.y = FPositionDialog.this.stringToDouble(FPositionDialog.this.getTDesdeDerecha().getText().toString());
                    r.width = FPositionDialog.this.stringToDouble(FPositionDialog.this.getTAnchura().getText().toString());
                    r.height = FPositionDialog.this.stringToDouble(FPositionDialog.this.getTAltura().getText().toString());
                    try {
                        IFFrame fframeAux = (IFFrame)FPositionDialog.this.fframe.clone();
                        fframeAux.setBoundBox(r);
                        FPositionDialog.this.layout.getLayoutContext().getFrameCommandsRecord().update(FPositionDialog.this.fframe, fframeAux);
                        FPositionDialog.this.layout.getLayoutContext().updateFFrames();
                    }
                    catch (CloneNotSupportedException e1) {
                        LOG.error("It is not possible clonate the object", (Object)e);
                    }
                    PluginServices.getMDIManager().closeWindow((IWindow)FPositionDialog.this);
                    FPositionDialog.this.observers.notifyObservers((Observable)FPositionDialog.this, (Object)new DefaultLayoutNotification("layout_invalidated"));
                    FPositionDialog.this.layout.repaint();
                }
            });
        }
        return this.bAceptar;
    }

    private double stringToDouble(String s) {
        String snew = s.replace(',', '.');
        return this.layout.getLayoutContext().getAttributes().fromUnits(Double.parseDouble(snew));
    }

    private JButton getBCancelar() {
        if (this.bCancelar == null) {
            this.bCancelar = new JButton();
            this.bCancelar.setBounds(107, 185, 87, 23);
            this.bCancelar.setText(PluginServices.getText((Object)this, (String)"Cancelar"));
            this.bCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginServices.getMDIManager().closeWindow((IWindow)FPositionDialog.this);
                }
            });
        }
        return this.bCancelar;
    }

    private JTextField getTDesdeIzquierda() {
        if (this.tDesdeIzquierda == null) {
            this.tDesdeIzquierda = new JTextField();
            this.tDesdeIzquierda.setBounds(132, 85, 53, 20);
            this.tDesdeIzquierda.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().toUnits(this.fframe.getBoundBox().x))));
        }
        return this.tDesdeIzquierda;
    }

    private JTextField getTDesdeDerecha() {
        if (this.tDesdeDerecha == null) {
            this.tDesdeDerecha = new JTextField();
            this.tDesdeDerecha.setBounds(132, 110, 53, 20);
            this.tDesdeDerecha.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().toUnits(this.fframe.getBoundBox().y))));
        }
        return this.tDesdeDerecha;
    }

    private JTextField getTAnchura() {
        if (this.tAnchura == null) {
            this.tAnchura = new JTextField();
            this.tAnchura.setBounds(132, 135, 53, 20);
            this.tAnchura.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().toUnits(this.fframe.getBoundBox().width))));
        }
        return this.tAnchura;
    }

    private JTextField getTAltura() {
        if (this.tAltura == null) {
            this.tAltura = new JTextField();
            this.tAltura.setBounds(132, 160, 53, 20);
            this.tAltura.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().toUnits(this.fframe.getBoundBox().height))));
        }
        return this.tAltura;
    }

    private JLabel getLNomUnidades() {
        if (this.lNomUnidades == null) {
            this.lNomUnidades = new JLabel();
            this.lNomUnidades.setBounds(91, 7, 91, 20);
            this.lNomUnidades.setText(PluginServices.getText((Object)this, (String)this.m_NameUnit));
        }
        return this.lNomUnidades;
    }

    private JLabel getLUnidades() {
        if (this.lUnidades == null) {
            this.lUnidades = new JLabel();
            this.lUnidades.setBounds(7, 7, 72, 20);
            this.lUnidades.setText(PluginServices.getText((Object)this, (String)"unidades"));
        }
        return this.lUnidades;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"tamano_posicion"));
        return m_viewinfo;
    }

    public void viewActivated() {
    }

    private JLabel getLAnchoUnidades() {
        if (this.lAnchoUnidades == null) {
            this.lAnchoUnidades = new JLabel();
            if (this.layout.getLayoutContext().getAttributes().isLandscape()) {
                this.lAnchoUnidades.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().getSizeInUnits().getHeight())));
            } else {
                this.lAnchoUnidades.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().getSizeInUnits().getWidth())));
            }
        }
        return this.lAnchoUnidades;
    }

    private JLabel getLAlto() {
        if (this.lAlto == null) {
            this.lAlto = new JLabel();
            this.lAlto.setText(PluginServices.getText((Object)this, (String)"alto"));
        }
        return this.lAlto;
    }

    private JLabel getLAltoUnidades() {
        if (this.lAltoUnidades == null) {
            this.lAltoUnidades = new JLabel();
            if (this.layout.getLayoutContext().getAttributes().isLandscape()) {
                this.lAltoUnidades.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().getSizeInUnits().getWidth())));
            } else {
                this.lAltoUnidades.setText(String.valueOf(this.nf.format(this.layout.getLayoutContext().getAttributes().getSizeInUnits().getHeight())));
            }
        }
        return this.lAltoUnidades;
    }

    private JLabel getLAncho() {
        if (this.lAncho == null) {
            this.lAncho = new JLabel();
            this.lAncho.setText(PluginServices.getText((Object)this, (String)"ancho"));
        }
        return this.lAncho;
    }

    private JPanel getPFolio() {
        if (this.pFolio == null) {
            this.pFolio = new JPanel();
            this.pFolio.add((Component)this.getLAltoUnidades(), null);
            this.pFolio.add((Component)this.getLAlto(), null);
            this.pFolio.add((Component)this.getLSeparador(), null);
            this.pFolio.add((Component)this.getLAnchoUnidades(), null);
            this.pFolio.add((Component)this.getLAncho(), null);
            this.pFolio.setBounds(9, 31, 180, 43);
            this.pFolio.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"tamanyo_pagina"), 0, 0, null, null));
        }
        return this.pFolio;
    }

    private JLabel getLSeparador() {
        if (this.lSeparador == null) {
            this.lSeparador = new JLabel();
            this.lSeparador.setText("/");
        }
        return this.lSeparador;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }
}

