/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools;

import java.awt.Image;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameEditableVertex;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.AbstractLayoutToolListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutEditGraphicsListenerImpl
extends AbstractLayoutToolListener
implements LayoutMoveListener {
    public static final Image icrux = PluginServices.getIconTheme().get("cursor-layout-graphic-edit-vertex").getImage();

    public LayoutEditGraphicsListenerImpl(LayoutPanel layoutPanel) {
        super(layoutPanel);
    }

    @Override
    public void drag(PointEvent event) {
        IFFrame[] fframes = this.layoutPanel.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame frame = fframes[i];
            if (!(frame instanceof IFFrameEditableVertex)) continue;
            ((IFFrameEditableVertex)((Object)frame)).pointDragged(FLayoutUtilities.toSheetPoint(event.getPoint(), this.layoutPanel.getLayoutControl().getAT()));
        }
    }

    @Override
    public Image getImageCursor() {
        return icrux;
    }

    @Override
    public boolean cancelDrawing() {
        return true;
    }

    @Override
    public void press(PointEvent event) throws BehaviorException {
        IFFrame[] fframes = this.layoutPanel.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame frame = fframes[i];
            if (!(frame instanceof IFFrameEditableVertex)) continue;
            ((IFFrameEditableVertex)((Object)frame)).pointPressed(FLayoutUtilities.toSheetPoint(event.getPoint(), this.layoutPanel.getLayoutControl().getAT()));
        }
    }

    @Override
    public void release(PointEvent event) throws BehaviorException {
        IFFrame[] fframes = this.layoutPanel.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame frame = fframes[i];
            if (!(frame instanceof IFFrameEditableVertex) || frame.getSelected() == 0 || !((IFFrameEditableVertex)((Object)frame)).isEditing()) continue;
            try {
                IFFrame fframeAux = (IFFrame)frame.clone();
                ((IFFrameEditableVertex)((Object)fframeAux)).startEditing();
                ((IFFrameEditableVertex)((Object)fframeAux)).pointReleased(FLayoutUtilities.toSheetPoint(event.getPoint(), this.layoutPanel.getLayoutControl().getAT()), ((IFFrameEditableVertex)((Object)frame)).getGeometry());
                this.layoutPanel.getLayoutContext().getFrameCommandsRecord().update(frame, fframeAux);
                fframeAux.getBoundingBox(this.layoutPanel.getLayoutControl().getAT());
                this.layoutPanel.getLayoutContext().updateFFrames();
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new BehaviorException("It is not possible to clone the object", (Throwable)e);
            }
        }
        this.layoutPanel.getLayoutControl().refresh();
    }

    @Override
    public void click(PointEvent event) {
    }

    @Override
    public void move(PointEvent event) throws BehaviorException {
    }
}

