/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.AbstractLayoutToolListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutPanListenerImpl
extends AbstractLayoutToolListener
implements LayoutMoveListener {
    public static final Image iLayoutpan = PluginServices.getIconTheme().get("layout-pan-icon").getImage();

    public LayoutPanListenerImpl(LayoutPanel layoutPanel) {
        super(layoutPanel);
    }

    @Override
    public void drag(PointEvent event) {
        Point pLast = this.layoutPanel.getLayoutControl().getLastPoint();
        Point pAnt = this.layoutPanel.getLayoutControl().getPointAnt();
        Point origin = this.layoutPanel.getLayoutControl().getRectOrigin();
        Rectangle2D.Double r = this.layoutPanel.getLayoutControl().getRect();
        r.x = origin.getX() + pLast.getX() - pAnt.getX();
        r.y = origin.getY() + pLast.getY() - pAnt.getY();
        this.layoutPanel.getLayoutControl().setRect(r);
    }

    @Override
    public Image getImageCursor() {
        return iLayoutpan;
    }

    @Override
    public boolean cancelDrawing() {
        return true;
    }

    @Override
    public void press(PointEvent event) throws BehaviorException {
        this.layoutPanel.getLayoutControl().getRectOrigin().setLocation(this.layoutPanel.getLayoutControl().getRect().x, this.layoutPanel.getLayoutControl().getRect().y);
    }

    @Override
    public void release(PointEvent event) throws BehaviorException {
        if (event.getEvent().getButton() == 1) {
            Point p1 = this.layoutPanel.getLayoutControl().getFirstPoint();
            Point p2 = event.getEvent().getPoint();
            this.layoutPanel.getLayoutControl().getLayoutZooms().setPan(p1, p2);
            this.layoutPanel.getLayoutControl().refresh();
            PluginServices.getMainFrame().enableControls();
        }
        this.layoutPanel.getLayoutControl().setFirstPoint();
        this.layoutPanel.getLayoutControl().setLastPoint();
        this.layoutPanel.getLayoutControl().setPointAnt();
        this.layoutPanel.getLayoutControl().getRectOrigin().setLocation(this.layoutPanel.getLayoutControl().getRect().x, this.layoutPanel.getLayoutControl().getRect().y);
    }

    @Override
    public void move(PointEvent event) throws BehaviorException {
    }

    @Override
    public void click(PointEvent event) throws BehaviorException {
    }
}

