/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutManager;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.layout.mapbox.MapBoxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutMapBoxExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(LayoutMapBoxExtension.class);

    public void initialize() {
        this.registerIcons();
    }

    public void postInitialize() {
        DefaultLayoutManager layoutManager = (DefaultLayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        MapBoxUtils.registerPersistence();
        MapBoxUtils.register(layoutManager);
        MapBoxUtils.registerContextMenuOptions();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"layout-insert-mapbox", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-edit-mapbox", (Object)((Object)this));
    }

    public void execute(String s) {
        LayoutPanel layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        LayoutControl control = layout.getLayoutControl();
        logger.debug("Comand : " + s);
        switch (s) {
            case "layout-insert-mapbox": {
                MapBoxUtils.addLayoutAddMapBoxTool(layout, control);
                control.setTool("layoutaddmapbox");
                layout.getDocument().setModified(true);
                break;
            }
            case "layout-edit-mapbox": {
                MapBoxUtils.addLayoutEditMapBoxTool(layout, control);
                control.setTool("layouteditmapbox");
                layout.getDocument().setModified(true);
                break;
            }
        }
    }

    public boolean isEnabled() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        if (f instanceof LayoutPanel) {
            return ((LayoutPanel)f).getLayoutContext().isEditable();
        }
        return false;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof LayoutPanel;
    }
}

