/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.fframe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.layout.mapbox.model.Cell;
import org.gvsig.layout.mapbox.model.Dimension2DDouble;
import org.gvsig.layout.mapbox.model.MapBoxModel;
import org.gvsig.layout.mapbox.model.SelectionCell;
import org.gvsig.layout.mapbox.model.SelectionCellImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameMapBox
extends FFrame {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameMapBox";
    public static final double PIXELS_TOLERANCE = 2.0;
    public static final double MAPBOX_EPSILON = 0.001;
    private MapBoxModel model;
    private SelectionCell selection = new SelectionCellImpl();

    public void setModel(MapBoxModel model) {
        this.model = model;
    }

    public MapBoxModel getModel() {
        return this.model;
    }

    public SelectionCell getSelection() {
        return this.selection;
    }

    public List<Cell> getSelectedCells() {
        Rectangle2D r = ((SelectionCellImpl)this.selection).getRectangle();
        if (r == null) {
            return Collections.EMPTY_LIST;
        }
        return this.model.getCells(r);
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        this.draw(g, at);
    }

    public void draw(Graphics2D g, AffineTransform at) {
        if (this.model == null) {
            return;
        }
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        g.setColor(Color.BLACK);
        List<Cell> selectedCells = this.getSelectedCells();
        for (Cell cell : this.model.getCells()) {
            this.drawCell(g, cell, this.getBoundBox(), selectedCells.contains(cell));
        }
        for (Cell cell : selectedCells) {
            this.drawCell(g, cell, this.getBoundBox(), true);
        }
        this.drawFrame(g, r);
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    public void drawCell(Graphics2D g, Cell cell, Rectangle2D rect, boolean selected) {
        Rectangle2D cellRect = cell.getRectangle();
        Rectangle2D.Double r2 = new Rectangle2D.Double(cellRect.getX() + rect.getX(), cellRect.getY() + rect.getY(), cellRect.getWidth(), cellRect.getHeight());
        Rectangle2D.Double r = FLayoutUtilities.fromSheetRect(r2, this.lastAT);
        if (selected) {
            g.setColor(Color.yellow.brighter());
            g.fillRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
            g.setColor(Color.yellow.darker());
        } else {
            g.setColor(Color.black);
        }
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.black);
    }

    private void drawFrame(Graphics2D g, Rectangle2D r) {
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
        g.setColor(Color.black);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"_Map_box") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void initialize() {
    }

    public void cloneActions(IFFrame frame) {
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, null, null);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameMapBox.class, PERSISTENCE_DEFINITION_NAME, "FFrameMapBox persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrame"));
            definition.addDynFieldObject("model").setClassOfValue(MapBoxModel.class).setMandatory(true);
            definition.addDynFieldObject("selection").setClassOfValue(SelectionCell.class).setDefaultFieldValue(null).setMandatory(false);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.model = (MapBoxModel)state.get("model");
        this.selection = (SelectionCell)state.get("selection");
        if (this.selection == null) {
            this.selection = new SelectionCellImpl();
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("model", (Persistent)this.model);
        state.set("selection", (Persistent)this.selection);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FFrameMapBox x = (FFrameMapBox)super.clone();
        x.model = (MapBoxModel)CloneableUtils.cloneQuietly((Cloneable)this.model);
        x.selection = (SelectionCell)CloneableUtils.cloneQuietly((Cloneable)this.selection);
        return x;
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        if (this.model != null) {
            this.model.resize(new Dimension2DDouble(r.getWidth(), r.getHeight()));
        }
        super.setBoundBox(r);
    }

    public void moveVerticalLine(double x0, double x1) {
        this.model.moveVerticalLine(x0, x1);
        if (MathUtils.equals((double)x0, (double)0.0, (double)0.001)) {
            this.m_BoundBox.x += x1;
            this.m_BoundBox.width -= x1 - x0;
        }
        if (MathUtils.equals((double)x0, (double)this.m_BoundBox.width, (double)0.001)) {
            this.m_BoundBox.width = x1;
        }
    }

    public void moveHorizontalLine(double y0, double y1) {
        this.model.moveHorizontalLine(y0, y1);
        if (MathUtils.equals((double)y0, (double)0.0, (double)0.001)) {
            this.m_BoundBox.y += y1;
            this.m_BoundBox.height -= y1 - y0;
        }
        if (MathUtils.equals((double)y0, (double)this.m_BoundBox.height, (double)0.001)) {
            this.m_BoundBox.height = y1;
        }
    }

    public void click(PointEvent event) {
    }

    public void drag(Point2D.Double toSheetPoint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Point2D.Double fromSheetPointToMapBoxPoint(Point2D.Double sheetPoint) {
        return new Point2D.Double(sheetPoint.x - this.m_BoundBox.x, sheetPoint.y - this.m_BoundBox.y);
    }

    public Point2D.Double fromMapBoxPointToSheetPoint(Point2D.Double mapBoxPoint) {
        return new Point2D.Double(this.m_BoundBox.x + mapBoxPoint.x, this.m_BoundBox.y + mapBoxPoint.y);
    }
}

