/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.json.JsonObject;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.spi.AbstractDownloaderAuthenticationRequester;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakConfig;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakFactory;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderKeycloakCredentials;
import org.gvsig.downloader.swing.scribejava.keycloak.KeycloakApi2;
import org.gvsig.downloader.swing.scribejava.keycloak.callbacks.CallbackAuthorizationHandler;
import org.gvsig.downloader.swing.scribejava.keycloak.callbacks.CallbackLogoutHandler;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderAuthenticationKeycloakRequester
extends AbstractDownloaderAuthenticationRequester
implements DownloaderAuthenticationRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloaderAuthenticationKeycloakRequester.class);
    private final Object monitor = new Object();
    private boolean stopedWaitingForResponse = false;
    private boolean userCancelledWaitingForResponse = false;
    private DownloaderKeycloakCredentials credentials = null;

    public DownloaderAuthenticationKeycloakRequester(DownloaderAuthenticationKeycloakConfig config) {
        super((DownloaderAuthenticationConfig)config);
    }

    public DownloaderAuthenticationKeycloakConfig getConfig() {
        return (DownloaderAuthenticationKeycloakConfig)this.config;
    }

    public boolean requestAuthorization(Executor executorUI) {
        try {
            String requestId = StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-");
            String authCallback = "http://localhost:" + this.getConfig().getLocalPort() + "/auth_" + requestId;
            OAuth20Service service = this.createService(authCallback);
            DownloaderKeycloakCredentials theCredentials = this.retrieveCredentials();
            if (theCredentials != null) {
                if (theCredentials.isAuthorizationTokenExpired()) {
                    if (!theCredentials.isRefreshTokenExpired()) {
                        OAuth2AccessToken token = theCredentials.getToken();
                        try {
                            token = service.refreshAccessToken(token.getRefreshToken());
                            if (token != null) {
                                System.out.println("ACCESS TOKEN UPDATED");
                                this.setCredentials(new DownloaderKeycloakCredentials(this.getConfig(), token, theCredentials.getUserid(), System.currentTimeMillis()));
                                return true;
                            }
                        }
                        catch (OAuth2AccessTokenErrorResponse ex) {
                            LOGGER.debug("Refresh access token failed", (Throwable)ex);
                        }
                    }
                    this.removeCredetials();
                } else {
                    this.setCredentials(theCredentials);
                    return true;
                }
            }
            return this.requestIdentification2(executorUI, requestId, authCallback, service);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't request authorization", (Throwable)ex);
            return false;
        }
    }

    private boolean requestIdentification2(Executor executorUI, String requestId, String authCallback, OAuth20Service service) {
        try {
            this.logout(executorUI, service, requestId);
            if (!this.isUserCancelledWaitingForResponse()) {
                this.authorize(executorUI, service, requestId);
            }
            this.applicationToFront();
            return this.credentials != null;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't request authorization", (Throwable)ex);
            return false;
        }
    }

    private void applicationToFront() {
        try {
            Window[] windows = Frame.getOwnerlessWindows();
            if (windows != null) {
                for (Window window : windows) {
                    try {
                        window.toFront();
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Can't bring to from " + window.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Can't bring to from application");
        }
    }

    private OAuth20Service createService(String authCallback) {
        String baseUrl = this.getConfig().getKeycloakBaseurl();
        String realm = this.getConfig().getRealm();
        String scope = this.getConfig().getScope();
        OAuth20Service service = new ServiceBuilder(this.getConfig().getClientid()).apiSecretIsEmptyStringUnsafe().defaultScope(scope).callback(authCallback).build((DefaultApi20)KeycloakApi2.instance(baseUrl, realm));
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authorize(Executor executorUI, OAuth20Service service, String requestId) throws IOException, URISyntaxException {
        DownloaderAuthenticationKeycloakFactory factory = this.getConfig().getFactory();
        String contextPath = "/auth_" + requestId;
        CallbackAuthorizationHandler callbackHandler = new CallbackAuthorizationHandler(this, service, contextPath);
        try {
            factory.addCallback(this.getConfig(), contextPath, callbackHandler);
            String authorizationUrl = service.getAuthorizationUrl();
            this.browse(authorizationUrl);
            this.waitForResponse(executorUI);
        }
        catch (Exception e) {
            LOGGER.warn("Can't authorize", (Throwable)e);
        }
        finally {
            callbackHandler.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logout(Executor executorUI, OAuth20Service service, String requestId) throws URISyntaxException, IOException {
        KeycloakApi2 api = (KeycloakApi2)service.getApi();
        DownloaderAuthenticationKeycloakFactory factory = this.getConfig().getFactory();
        String contextPath = "/logout_" + requestId;
        CallbackLogoutHandler callbackHandler = new CallbackLogoutHandler(this, service, contextPath);
        try {
            URLCodec urlcodec = new URLCodec();
            String redirect_uri = urlcodec.encode("http://localhost:" + this.getConfig().getLocalPort() + "/logout_" + requestId);
            String client_id = this.getConfig().getClientid();
            factory.addCallback(this.getConfig(), contextPath, callbackHandler);
            String logoutEndpoint = api.getLogoutEndpoint(client_id, redirect_uri);
            this.browse(logoutEndpoint);
            this.waitForResponse(executorUI);
        }
        catch (Exception e) {
            LOGGER.warn("Can't logout", (Throwable)e);
        }
        finally {
            callbackHandler.remove();
        }
    }

    private void browse(String url) throws URISyntaxException, IOException {
        DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
        System.out.println("BROWSE : " + url);
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        desktop.browse(new URI(url));
    }

    public JsonObject userInfo(OAuth20Service service) throws InterruptedException, IOException, ExecutionException {
        KeycloakApi2 api = (KeycloakApi2)service.getApi();
        String userInfoEndpoint = api.getUserInfoEndpoint();
        System.out.println("userInfoEndpoint: " + userInfoEndpoint);
        OAuthRequest request = new OAuthRequest(Verb.GET, userInfoEndpoint);
        service.signRequest(this.getCredentials().getToken(), request);
        try (Response response = service.execute(request);){
            System.out.println("userInfo-response: " + response.toString());
            if (response.getCode() == 200) {
                JsonObject userinfo;
                JsonObject jsonObject = userinfo = Json.createObject((String)response.getBody());
                return jsonObject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResponse(Executor executorUI) {
        Object object = this.monitor;
        synchronized (object) {
            final ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            final I18nManager i18n = ToolsLocator.getI18nManager();
            try {
                this.stopedWaitingForResponse = false;
                this.userCancelledWaitingForResponse = false;
                while (!this.userCancelledWaitingForResponse && !this.stopedWaitingForResponse) {
                    this.monitor.wait(20000L);
                    if (this.stopedWaitingForResponse) continue;
                    executorUI.execute(new Runnable(){

                        @Override
                        public void run() {
                            int n = dialogs.confirmDialog(i18n.getTranslation("_Do_you_want_to_continue_waiting_for_the_authentication_to_complete"), i18n.getTranslation("_Authentication"), 0, 3);
                            if (n == 1) {
                                DownloaderAuthenticationKeycloakRequester.this.userCancelledWaitingForResponse = true;
                            }
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWaitingForResponse() {
        Object object = this.monitor;
        synchronized (object) {
            this.stopedWaitingForResponse = true;
            this.monitor.notifyAll();
        }
    }

    private boolean isUserCancelledWaitingForResponse() {
        return this.userCancelledWaitingForResponse;
    }

    public DownloaderKeycloakCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(DownloaderKeycloakCredentials credentials) {
        this.saveCredetials(credentials);
        this.credentials = credentials;
    }

    private DownloaderKeycloakCredentials retrieveCredentials() {
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        try {
            return (DownloaderKeycloakCredentials)manager.getCredentials(this.config.getServiceUrl());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void removeCredetials() {
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        manager.removeCredentials((DownloaderCredentials)this.credentials);
    }

    private void saveCredetials(DownloaderKeycloakCredentials credentials) {
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        manager.addOrReplaceCredentials((DownloaderCredentials)credentials);
    }
}

