/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak;

import com.github.scribejava.core.model.OAuth2AccessToken;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.spi.AbstractDownloaderCredentials;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakConfig;
import org.gvsig.json.Json;

public class DownloaderKeycloakCredentials
extends AbstractDownloaderCredentials
implements DownloaderCredentials {
    private final OAuth2AccessToken oauthToken;
    private final String userid;
    private long time;
    private JsonObject jsonResponse;
    private final DownloaderAuthenticationKeycloakConfig config;

    public DownloaderKeycloakCredentials(DownloaderAuthenticationKeycloakConfig config, OAuth2AccessToken oauthToken, String userid, long time) {
        super(userid, config.getServiceUrl());
        this.config = config;
        this.oauthToken = oauthToken;
        this.userid = userid;
        this.time = time;
        this.jsonResponse = null;
    }

    public OAuth2AccessToken getToken() {
        return this.oauthToken;
    }

    public String getAuthorizationToken() {
        return "Bearer " + this.oauthToken.getAccessToken();
    }

    public String getUserid() {
        return this.userid;
    }

    public boolean isAuthorizationTokenExpired() {
        try {
            long now = System.currentTimeMillis();
            long expires_in = this.getResponseValueInt("expires_in", -1);
            if (expires_in < 0L) {
                return true;
            }
            return this.time + expires_in * 1000L < now;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public boolean isRefreshTokenExpired() {
        try {
            long now = System.currentTimeMillis();
            long refresh_expires_in = this.getResponseValueInt("refresh_expires_in", -1);
            if (refresh_expires_in < 0L) {
                return true;
            }
            return this.time + refresh_expires_in * 1000L < now;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getResponseValueString(String name) {
        if (this.jsonResponse == null) {
            this.jsonResponse = Json.createObject((String)this.oauthToken.getRawResponse());
        }
        return this.jsonResponse.getString(name, null);
    }

    private int getResponseValueInt(String name, int defaultValue) {
        if (this.jsonResponse == null) {
            this.jsonResponse = Json.createObject((String)this.oauthToken.getRawResponse());
        }
        return this.jsonResponse.getInt(name, defaultValue);
    }

    public DownloaderAuthenticationKeycloakConfig getConfig() {
        return this.config;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        builder.append("providerName", (Object)this.providerName);
        builder.append("serviceUrl", (Object)this.serviceUrl);
        builder.append("userid", (Object)this.userid);
        builder.append("AuthorizationToken", (Object)this.getAuthorizationToken());
        return builder.build();
    }

    public DownloaderCredentials createCredentials(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        DownloaderAuthenticationConfig theConfig = downloader.getAuthenticationConfigurationService(serviceUrl);
        if (theConfig == null) {
            theConfig = this.config.createAuthenticationConfig(serviceUrl);
        }
        return new DownloaderKeycloakCredentials((DownloaderAuthenticationKeycloakConfig)theConfig, this.getToken(), this.getUserid(), this.getTime());
    }

    public DownloaderCredentials createCredentials(DownloaderAuthenticationConfig config) {
        if (!this.isCompatible(config)) {
            return null;
        }
        return new DownloaderKeycloakCredentials((DownloaderAuthenticationKeycloakConfig)config, this.getToken(), this.getUserid(), this.getTime());
    }

    public boolean isCompatible(DownloaderAuthenticationConfig config) {
        if (!(config instanceof DownloaderAuthenticationKeycloakConfig)) {
            return false;
        }
        DownloaderAuthenticationKeycloakConfig otherConfig = (DownloaderAuthenticationKeycloakConfig)config;
        DownloaderAuthenticationKeycloakConfig myConfig = this.getConfig();
        if (!DownloaderManager.areSameURLs((String)myConfig.getKeycloakBaseurl(), (String)otherConfig.getKeycloakBaseurl())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)myConfig.getRealm(), (CharSequence)otherConfig.getRealm())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)myConfig.getClientid(), (CharSequence)otherConfig.getClientid())) {
            return false;
        }
        return StringUtils.equals((CharSequence)myConfig.getScope(), (CharSequence)otherConfig.getScope());
    }
}

