/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.devel;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class BenchmarkAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int y;
        int x;
        long lTime = System.currentTimeMillis();
        double dSum = 0.0;
        for (x = 0; x < 100000000; ++x) {
            dSum += 1.0;
        }
        long lTime2 = System.currentTimeMillis();
        System.out.println("A simple loop:" + Long.toString(lTime2 - lTime));
        IRasterLayer layer = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        layer.setFullExtent();
        int iNX = layer.getWindowGridExtent().getNX();
        int iNY = layer.getWindowGridExtent().getNY();
        lTime = System.currentTimeMillis();
        for (y = 0; y < iNY; ++y) {
            for (x = 0; x < iNX; ++x) {
                layer.getCellValueAsDouble(x, y);
            }
        }
        lTime2 = System.currentTimeMillis();
        System.out.println("Reading values:" + Long.toString(lTime2 - lTime));
        lTime = System.currentTimeMillis();
        layer = this.getTempRasterLayer(5, layer.getLayerGridExtent());
        lTime2 = System.currentTimeMillis();
        System.out.println("Layer creation:" + Long.toString(lTime2 - lTime));
        iNX = layer.getWindowGridExtent().getNX();
        iNY = layer.getWindowGridExtent().getNY();
        lTime = System.currentTimeMillis();
        for (y = 0; y < iNY; ++y) {
            for (x = 0; x < iNX; ++x) {
                layer.setCellValue(x, y, 1.0);
            }
        }
        lTime2 = System.currentTimeMillis();
        System.out.println("Writing values:" + Long.toString(lTime2 - lTime));
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Benchmarking"));
        this.setGroup(Sextante.getText((String)"Development"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, "Input", true);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

