/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.costInRoutes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;

public class CostInRoutesAlgorithm
extends GeoAlgorithm {
    public static final String ROUTES = "ROUTES";
    public static final String COST = "COST";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_Cost;
    private double[] m_dDist;
    private double[] m_dCost;
    private double m_dLastX;
    private double m_dLastY;
    private int m_iPoints = 0;
    private int m_iCurrentRoute;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cost_for_predefined_routes"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(ROUTES, Sextante.getText((String)"Routes"), 1, true);
            this.m_Parameters.addInputRasterLayer(COST, Sextante.getText((String)"Cost"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Routes_and_cost"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer routes = this.m_Parameters.getParameterValueAsVectorLayer(ROUTES);
        this.m_Cost = this.m_Parameters.getParameterValueAsRasterLayer(COST);
        if (routes.getShapesCount() == 0) {
            return false;
        }
        int iShapesCount = routes.getShapesCount();
        this.m_iCurrentRoute = 0;
        this.m_Cost.setFullExtent();
        this.m_dCost = new double[routes.getShapesCount()];
        this.m_dDist = new double[routes.getShapesCount()];
        IFeatureIterator iter = routes.iterator();
        while (iter.hasNext() && this.setProgress(this.m_iCurrentRoute, iShapesCount)) {
            this.m_iPoints = 0;
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            this.processLine(geom.getCoordinates());
            ++this.m_iCurrentRoute;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Object[][] values = new Object[2][routes.getShapesCount()];
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"Cost")};
        Class[] types = new Class[]{Double.class, Double.class};
        for (int i = 0; i < routes.getShapesCount(); ++i) {
            values[0][i] = new Double(this.m_dDist[i]);
            values[1][i] = new Double(this.m_dCost[i]);
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setDescription(Sextante.getText((String)"Routes"));
        out.setOutputChannel(channel);
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)routes, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return true;
    }

    private void processLine(Coordinate[] coords) {
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.processSegment(x, y, x2, y2);
        }
    }

    private void processSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.m_Cost.getWindowCellSize();
                dy /= dx;
                dx = this.m_Cost.getWindowCellSize();
            } else {
                n = dy /= this.m_Cost.getWindowCellSize();
                dx /= dy;
                dy = this.m_Cost.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                this.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void addPoint(double x, double y) {
        double z = this.m_Cost.getValueAt(x, y);
        if (this.m_iPoints == 0) {
            this.m_dDist[this.m_iCurrentRoute] = 0.0;
            this.m_dCost[this.m_iCurrentRoute] = 0.0;
        } else {
            double dDX = x - this.m_dLastX;
            double dDY = y - this.m_dLastY;
            int n = this.m_iCurrentRoute;
            this.m_dDist[n] = this.m_dDist[n] + Math.sqrt(dDX * dDX + dDY * dDY);
            if (!this.m_Cost.isNoDataValue(z)) {
                int n2 = this.m_iCurrentRoute;
                this.m_dCost[n2] = this.m_dCost[n2] + z;
            }
        }
        this.m_dLastX = x;
        this.m_dLastY = y;
        ++this.m_iPoints;
    }
}

