/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.rectToPolar;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class RectToPolarAlgorithm
extends GeoAlgorithm {
    public static final String ANGLE = "ANGLE";
    public static final String DIST = "DIST";
    public static final String X = "X";
    public static final String Y = "Y";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Distance;
    IRasterLayer m_Angle;
    IRasterLayer m_X;
    IRasterLayer m_Y;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cartesian_to_polar"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(X, Sextante.getText((String)X), true);
            this.m_Parameters.addInputRasterLayer(Y, Sextante.getText((String)Y), true);
            this.addOutputRasterLayer(ANGLE, Sextante.getText((String)"Angle"));
            this.addOutputRasterLayer(DIST, Sextante.getText((String)"Distance"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_X = this.m_Parameters.getParameterValueAsRasterLayer(X);
        this.m_Y = this.m_Parameters.getParameterValueAsRasterLayer(Y);
        this.m_Distance = this.getNewRasterLayer(DIST, Sextante.getText((String)"Distance"), 5);
        this.m_Angle = this.getNewRasterLayer(ANGLE, Sextante.getText((String)"Angle"), 5);
        AnalysisExtent extent = this.m_Distance.getWindowGridExtent();
        this.m_X.setWindowExtent(extent);
        this.m_Y.setWindowExtent(extent);
        this.m_iNX = extent.getNX();
        this.m_iNY = extent.getNY();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dX = this.m_X.getCellValueAsDouble(x, y);
                double dY = this.m_Y.getCellValueAsDouble(x, y);
                if (!this.m_Y.isNoDataValue(dY) && !this.m_X.isNoDataValue(dX)) {
                    double dDist = Math.sqrt(dX * dX + dY * dY);
                    double dAngle = Math.atan(dY / dX);
                    if (dX * dY > 0.0) {
                        if (dY < 0.0 && dX < 0.0) {
                            dAngle += Math.PI;
                        }
                    } else {
                        dAngle = dY < 0.0 ? Math.PI * 2 - dAngle : Math.PI - dAngle;
                    }
                    this.m_Distance.setCellValue(x, y, dDist);
                    this.m_Angle.setCellValue(x, y, dAngle);
                    continue;
                }
                this.m_Distance.setNoData(x, y);
                this.m_Angle.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

