/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.generateRandomBernoulli;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GenerateRandomBernoulliAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String PROB = "PROB";
    private IRasterLayer m_Result;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dProb = this.m_Parameters.getParameterValueAsDouble(PROB) / 100.0;
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"New_layer"), 3);
        int iNX = this.m_Result.getWindowGridExtent().getNX();
        int iNY = this.m_Result.getWindowGridExtent().getNY();
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = Math.random();
                boolean iValue = dValue < dProb;
                this.m_Result.setCellValue(x, y, (double)iValue);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Random_grid__Bernouilli"));
        this.setGroup(Sextante.getText((String)"Raster_creation_tools"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(PROB, Sextante.getText((String)"Probability__%"), 2, 50.0, 0.0, 100.0);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Probability"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

