/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.normalize;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class NormalizeAlgorithm
extends GeoAlgorithm {
    public static final String GRID = "GRID";
    public static final String METHOD = "METHOD";
    public static final String RESULT = "RESULT";
    public static final int METHOD_NORMALIZE = 0;
    public static final int METHOD_FROM_0_TO_1 = 1;
    private int m_iNX;
    private int m_iNY;
    private int m_iMethod;
    private IRasterLayer m_Grid = null;
    private IRasterLayer m_NormalizedGrid;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_NormalizedGrid = this.getNewRasterLayer(RESULT, this.m_Grid.getName() + Sextante.getText((String)"[normalized]"), 5);
        this.m_Grid.setWindowExtent(this.getAnalysisExtent());
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        return this.normalize();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Standard_deviation"), "0 < x < 1"};
        this.setName(Sextante.getText((String)"Normalize"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Layer_to_normalize"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Normalized"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean normalize() throws GeoAlgorithmExecutionException {
        double dValue1 = 0.0;
        double dValue2 = 0.0;
        switch (this.m_iMethod) {
            case 0: {
                dValue1 = this.m_Grid.getMeanValue();
                dValue2 = Math.sqrt(this.m_Grid.getVariance());
                break;
            }
            default: {
                dValue1 = this.m_Grid.getMinValue();
                dValue2 = this.m_Grid.getMaxValue() - dValue1;
            }
        }
        if (dValue2 == 0.0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Cannot normalize layer. Wrong values"));
        }
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double z = this.m_Grid.getCellValueAsDouble(x, y);
                if (!this.m_Grid.isNoDataValue(z)) {
                    this.m_NormalizedGrid.setCellValue(x, y, (z - dValue1) / dValue2);
                    continue;
                }
                this.m_NormalizedGrid.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

