/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.volume;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.text.DecimalFormat;

public class VolumeAlgorithm
extends GeoAlgorithm {
    public static final String BASE = "BASE";
    public static final String METHOD = "METHOD";
    public static final String GRID = "GRID";
    public static final String VOL = "VOL";
    public static final int METHOD_ONLY_OVER_BASE_LEVEL = 0;
    public static final int METHOD_ONLY_UNDER_BASE_LEVEL = 1;
    public static final int SUM_OVER_BASE_LEVEL_SUBSTRACT_UNDER_BASE_LEVEL = 2;
    public static final int SUM_VOLUMES_BOTH_OVER_AND_UNDER_BASE_LEVEL = 3;
    private int m_iNX;
    private int m_iNY;
    private double m_BaseLevel;
    private IRasterLayer m_Grid = null;
    private int m_iMethod;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_BaseLevel = this.m_Parameters.getParameterValueAsDouble(BASE);
        this.m_Grid.setWindowExtent(this.m_AnalysisExtent);
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        return this.calculateVolumes();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Only_volumes_over_base_level"), Sextante.getText((String)"Only_volumes_below_base_level"), Sextante.getText((String)"Add_volumes_over_base_level_and_substract_volumes_below_it"), Sextante.getText((String)"Add_volumes_both_over_and_below_base_level")};
        this.setName(Sextante.getText((String)"Volume_calculation"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(BASE, Sextante.getText((String)"Base_level"), 2, 1000.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputText(VOL, Sextante.getText((String)"Volume"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean calculateVolumes() {
        double dVolume = 0.0;
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            block7: for (int x = 0; x < this.m_iNX; ++x) {
                double z = this.m_Grid.getCellValueAsDouble(x, y);
                if (this.m_Grid.isNoDataValue(z)) continue;
                z -= this.m_BaseLevel;
                switch (this.m_iMethod) {
                    case 0: {
                        if (!(z > 0.0)) continue block7;
                        dVolume += z;
                        continue block7;
                    }
                    case 1: {
                        if (!(z < 0.0)) continue block7;
                        dVolume -= z;
                        continue block7;
                    }
                    case 2: {
                        dVolume += z;
                        continue block7;
                    }
                    case 3: {
                        dVolume += Math.abs(z);
                    }
                }
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        dVolume *= this.m_Grid.getWindowCellSize() * this.m_Grid.getWindowCellSize();
        DecimalFormat df = new DecimalFormat("##.##");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Volumes"));
        doc.addHeader(Sextante.getText((String)"Volumes"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Calculated_volume") + ": " + df.format(dVolume));
        doc.close();
        this.addOutputText(VOL, Sextante.getText((String)"Volume") + "[" + this.m_Grid.getName() + "]", doc.getHTMLCode());
        return true;
    }
}

