/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.classStatistics;

public class ClassStatistics {
    private final int m_iClass;
    private int m_iZonesCount = 0;
    private double m_dSum = 0.0;
    private double m_dVar = 0.0;
    private double m_dMin = Double.MAX_VALUE;
    private double m_dMax = 0.0;

    ClassStatistics(int iClass) {
        this.m_iClass = iClass;
    }

    public void add(double dArea) {
        ++this.m_iZonesCount;
        this.m_dSum += dArea;
        this.m_dVar += dArea * dArea;
        this.m_dMax = Math.max(this.m_dMax, dArea);
        this.m_dMin = Math.min(this.m_dMin, dArea);
    }

    public int getClassID() {
        return this.m_iClass;
    }

    public double getTotalArea() {
        return this.m_dSum;
    }

    public double getMinArea() {
        return this.m_dMin;
    }

    public double getMaxArea() {
        return this.m_dMax;
    }

    public double getMeanArea() {
        return this.m_dSum / (double)this.m_iZonesCount;
    }

    public double getVarianceArea() {
        double dMean = this.getMeanArea();
        return this.m_dVar / (double)this.m_iZonesCount - dMean * dMean;
    }

    public int getZonesCount() {
        return this.m_iZonesCount;
    }
}

