/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.classStatistics;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gridCategorical.classStatistics.ClassStatistics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ClassStatisticsAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String RESULT = "RESULT";
    public static final String INPUT = "INPUT";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Grid;
    HashMap m_Map;
    boolean[][] m_IsCellAlreadyVisited;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Class_statistics"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputTable(RESULT, Sextante.getText((String)"Class_statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ClassStatistics stats = null;
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Grid.setWindowExtent(this.m_AnalysisExtent);
        this.m_Grid.setInterpolationMethod(0);
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        this.m_IsCellAlreadyVisited = new boolean[this.m_iNX][this.m_iNY];
        this.m_Map = new HashMap();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                if (this.m_IsCellAlreadyVisited[x][y]) continue;
                int iClass = this.m_Grid.getCellValueAsInt(x, y);
                double dArea = this.getClassArea(x, y);
                stats = (ClassStatistics)this.m_Map.get(new Integer(iClass));
                if (stats != null) {
                    stats.add(dArea);
                    continue;
                }
                stats = new ClassStatistics(iClass);
                stats.add(dArea);
                this.m_Map.put(new Integer(iClass), stats);
            }
        }
        if (!this.m_Task.isCanceled()) {
            this.createTable();
            return true;
        }
        return false;
    }

    private void createTable() throws UnsupportedOutputChannelException {
        Set set = this.m_Map.keySet();
        Iterator iter = set.iterator();
        String[] sFields = new String[]{Sextante.getText((String)"Class_ID"), Sextante.getText((String)"total_area_Total"), Sextante.getText((String)"Number_of_patches"), Sextante.getText((String)"Mean_area"), Sextante.getText((String)"Variance_of_area"), Sextante.getText((String)"Max_area"), Sextante.getText((String)"Min_area")};
        Class[] types = new Class[]{Integer.class, Double.class, Integer.class, Double.class, Double.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Class_statistics_[") + this.m_Grid.getName() + "]";
        ITable table = this.getNewTable(RESULT, sTableName, types, sFields);
        Object[] values = new Object[7];
        while (iter.hasNext()) {
            ClassStatistics stats = (ClassStatistics)this.m_Map.get(iter.next());
            values[0] = new Integer(stats.getClassID());
            values[1] = new Double(stats.getTotalArea());
            values[2] = new Integer(stats.getZonesCount());
            values[3] = new Double(stats.getMeanArea());
            values[4] = new Double(stats.getVarianceArea());
            values[5] = new Double(stats.getMaxArea());
            values[6] = new Double(stats.getMinArea());
            table.addRecord(values);
        }
    }

    private double getClassArea(int x, int y) {
        double dArea = 0.0;
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Grid.getCellValueAsInt(x, y);
        centralPoints.add(new Point(x, y));
        this.m_IsCellAlreadyVisited[x][y] = true;
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                dArea += this.m_Grid.getWindowCellSize() * this.m_Grid.getWindowCellSize();
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                double dClass = this.m_Grid.getCellValueAsInt(x, y);
                if (this.m_Grid.isNoDataValue(dClass)) continue;
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    dClass = this.m_Grid.getCellValueAsDouble(x2, y2);
                    if (this.m_Grid.isNoDataValue(dClass)) continue;
                    int iClass = (int)dClass;
                    if (this.m_IsCellAlreadyVisited[x2][y2] || iInitClass != iClass) continue;
                    this.m_IsCellAlreadyVisited[x2][y2] = true;
                    adjPoints.add(new Point(x2, y2));
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
        }
        return dArea;
    }
}

