/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.crossClassification;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class CrossClassificationAlgorithm
extends GeoAlgorithm {
    public static final String KAPPA = "KAPPA";
    public static final String CROSSCLASS = "CROSCLASS";
    public static final String GRID = "GRID";
    public static final String GRID2 = "GRID2";
    public static final String TABLE = "TABLE";
    int m_iNX;
    int m_iNY;
    HashMap m_Map;
    ArrayList m_List;
    IRasterLayer m_Window;
    IRasterLayer m_Window2;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cross_checking_Kappa_index"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Grid_1"), true);
            this.m_Parameters.addInputRasterLayer(GRID2, Sextante.getText((String)"Grid_2"), true);
            this.addOutputTable(TABLE, Sextante.getText((String)"Cross_classification"));
            this.addOutputRasterLayer(CROSSCLASS, Sextante.getText((String)"Cross_classification"));
            this.addOutputText(KAPPA, Sextante.getText((String)"Cross_classification"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int j;
        int i;
        int iValidCells = 0;
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        this.m_Window2 = this.m_Parameters.getParameterValueAsRasterLayer(GRID2);
        IRasterLayer result = this.getNewRasterLayer(CROSSCLASS, this.m_Window.getName() + " + " + this.m_Window2.getName(), 3);
        this.m_Window.setWindowExtent(result.getWindowGridExtent());
        this.m_Window.setInterpolationMethod(0);
        this.m_Window2.setWindowExtent(result.getWindowGridExtent());
        this.m_Window2.setInterpolationMethod(0);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.createMap();
        int iValueCount = this.m_Map.size();
        int[][] table = new int[iValueCount][iValueCount];
        int[] iSum = new int[iValueCount];
        int[] iSum2 = new int[iValueCount];
        for (i = 0; i < iValueCount; ++i) {
            iSum[i] = 0;
            iSum2[i] = 0;
            for (j = 0; j < iValueCount; ++j) {
                table[i][j] = 0;
            }
        }
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                int iCellValue = this.m_Window.getCellValueAsInt(x, y);
                int iCellValue2 = this.m_Window2.getCellValueAsInt(x, y);
                if (!this.m_Window.isNoDataValue((double)iCellValue) && !this.m_Window2.isNoDataValue((double)iCellValue2)) {
                    int iClass = (Integer)this.m_Map.get(new Integer(iCellValue));
                    int iClass2 = (Integer)this.m_Map.get(new Integer(iCellValue2));
                    result.setCellValue(x, y, (double)(iClass * iValueCount + iClass2));
                    int[] nArray = table[iClass];
                    int n = iClass2;
                    nArray[n] = nArray[n] + 1;
                    ++iValidCells;
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        for (i = 0; i < iValueCount; ++i) {
            for (j = 0; j < iValueCount; ++j) {
                int n = i;
                iSum[n] = iSum[n] + table[i][j];
                int n2 = j;
                iSum2[n2] = iSum2[n2] + table[i][j];
            }
        }
        double dP0 = 0.0;
        double dPc = 0.0;
        double[] dPartialKappa = new double[iValueCount];
        for (i = 0; i < iValueCount; ++i) {
            dP0 += (double)table[i][i];
            dPc += (double)(iSum[i] * iSum2[i]);
            double dPi = (double)table[i][i] / (double)iValidCells;
            double dPi2 = (double)iSum[i] / (double)iValidCells;
            double dPi3 = (double)iSum2[i] / (double)iValidCells;
            dPartialKappa[i] = (dPi - dPi2 * dPi3) / (dPi2 - dPi2 * dPi3);
        }
        double dKappa = ((dP0 /= (double)iValidCells) - (dPc /= (double)(iValidCells * iValidCells))) / (1.0 - dPc);
        DecimalFormat df = new DecimalFormat("##.##");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Index_of_agreement"));
        doc.addHeader(Sextante.getText((String)"Index_of_agreement"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Global_kappa") + ": " + df.format(dKappa));
        for (i = 0; i < iValueCount; ++i) {
            doc.addListElement(Sextante.getText((String)"Kappa_for_class") + ": " + Integer.toString(i) + ": " + df.format(dPartialKappa[i]));
        }
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(KAPPA, Sextante.getText((String)"Index_of_agreement") + "[" + this.m_Window.getName() + "-" + this.m_Window2.getName() + "]", doc.getHTMLCode());
        String sTableName = Sextante.getText((String)"Cross_checking");
        String[] sFields = new String[iValueCount];
        Class[] types = new Class[iValueCount];
        for (i = 0; i < iValueCount; ++i) {
            sFields[i] = (String)this.m_List.get(i);
            types[i] = Double.class;
        }
        ITable outputTable = this.getNewTable(TABLE, sTableName, types, sFields);
        Object[] values = new Object[iValueCount];
        for (i = 0; i < iValueCount; ++i) {
            for (j = 0; j < iValueCount; ++j) {
                values[j] = new Double(table[i][j]);
            }
            outputTable.addRecord(values);
        }
        return !this.m_Task.isCanceled();
    }

    private void createMap() {
        this.m_Map = new HashMap();
        this.m_List = new ArrayList();
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                Integer iID;
                Integer iClass;
                int iCellValue = this.m_Window.getCellValueAsInt(x, y);
                if (!this.m_Window.isNoDataValue((double)iCellValue) && !this.m_Map.containsKey(iClass = new Integer(iCellValue))) {
                    iID = new Integer(this.m_Map.size());
                    this.m_Map.put(iClass, iID);
                    this.m_List.add(iClass.toString());
                }
                if (this.m_Window2.isNoDataValue((double)(iCellValue = this.m_Window2.getCellValueAsInt(x, y))) || this.m_Map.containsKey(iClass = new Integer(iCellValue))) continue;
                iID = new Integer(this.m_Map.size());
                this.m_Map.put(iClass, iID);
                this.m_List.add(iClass.toString());
            }
        }
    }
}

