/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridStatistics.semivariances;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.util.Arrays;

public class SemivariancesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String MAXDIST = "MAXDIST";
    private int m_iNX;
    private int m_iNY;
    private int m_iMaxDist;
    private double[] m_dSemivarHorz;
    private double[] m_dSemivarVert;
    private int[] m_iValidCellsHorz;
    private int[] m_iValidCellsVert;
    private IRasterLayer m_Layer;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(false);
        this.setName(Sextante.getText((String)"Semivariances__raster"));
        this.setGroup(Sextante.getText((String)"Geostatistics"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(MAXDIST, Sextante.getText((String)"Maximum_distance__pixels"), 1, 20.0, 1.0, 2.147483647E9);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Semivariances"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMaxDist = this.m_Parameters.getParameterValueAsInt(MAXDIST);
        this.m_Layer = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Layer.setFullExtent();
        this.m_iNX = this.m_Layer.getNX();
        this.m_iNY = this.m_Layer.getNY();
        this.m_iMaxDist = Math.min(this.m_iMaxDist, this.m_iNX);
        this.m_iMaxDist = Math.min(this.m_iMaxDist, this.m_iNY);
        this.m_dSemivarHorz = new double[this.m_iMaxDist];
        this.m_dSemivarVert = new double[this.m_iMaxDist];
        this.m_iValidCellsHorz = new int[this.m_iMaxDist];
        this.m_iValidCellsVert = new int[this.m_iMaxDist];
        Arrays.fill(this.m_dSemivarHorz, 0.0);
        Arrays.fill(this.m_dSemivarVert, 0.0);
        Arrays.fill(this.m_iValidCellsHorz, 0);
        Arrays.fill(this.m_iValidCellsVert, 0);
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.calculateSemivariances(x, y);
            }
        }
        if (!this.m_Task.isCanceled()) {
            this.postProcessValues();
            this.createTable();
        }
        return !this.m_Task.isCanceled();
    }

    private void createTable() throws UnsupportedOutputChannelException {
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"Semivar__Horz"), Sextante.getText((String)"Semivar__Vert")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Semivariances[") + this.m_Layer.getName() + "]";
        Object[] values = new Object[3];
        ITable driver = this.getNewTable(RESULT, sTableName, types, sFields);
        for (int i = 0; i < this.m_iMaxDist; ++i) {
            values[0] = new Double(this.m_Layer.getWindowCellSize() * (double)i);
            values[1] = new Double(this.m_dSemivarHorz[i]);
            values[2] = new Double(this.m_dSemivarVert[i]);
            driver.addRecord(values);
        }
    }

    private void postProcessValues() {
        for (int i = 0; i < this.m_iMaxDist; ++i) {
            if (this.m_iValidCellsHorz[i] != 0) {
                int n = i;
                this.m_dSemivarHorz[n] = this.m_dSemivarHorz[n] / (2.0 * (double)this.m_iValidCellsHorz[i]);
            }
            if (this.m_iValidCellsVert[i] == 0) continue;
            int n = i;
            this.m_dSemivarVert[n] = this.m_dSemivarVert[n] / (2.0 * (double)this.m_iValidCellsVert[i]);
        }
    }

    private void calculateSemivariances(int iInitX, int iInitY) {
        double dValue;
        int iDist;
        double dCenterValue = this.m_Layer.getCellValueAsDouble(iInitX, iInitY);
        if (this.m_Layer.isNoDataValue(dCenterValue)) {
            return;
        }
        int x1 = Math.max(iInitX - this.m_iMaxDist, 0);
        int x2 = Math.min(iInitX + this.m_iMaxDist, this.m_iNX - 1);
        int y1 = Math.max(iInitY - this.m_iMaxDist, 0);
        int y2 = Math.min(iInitY + this.m_iMaxDist, this.m_iNY - 1);
        for (int x = x1; x < x2 + 1; ++x) {
            iDist = Math.abs(x - iInitX) - 1;
            if (iDist <= 0 || this.m_Layer.isNoDataValue(dValue = this.m_Layer.getCellValueAsDouble(x, iInitY))) continue;
            int n = iDist;
            this.m_dSemivarHorz[n] = this.m_dSemivarHorz[n] + Math.pow(dValue - dCenterValue, 2.0);
            int n2 = iDist;
            this.m_iValidCellsHorz[n2] = this.m_iValidCellsHorz[n2] + 1;
        }
        for (int y = y1; y < y2 + 1; ++y) {
            iDist = Math.abs(y - iInitY) - 1;
            if (iDist <= 0 || this.m_Layer.isNoDataValue(dValue = this.m_Layer.getCellValueAsDouble(iInitX, y))) continue;
            int n = iDist;
            this.m_dSemivarVert[n] = this.m_dSemivarVert[n] + Math.pow(dValue - dCenterValue, 2.0);
            int n3 = iDist;
            this.m_iValidCellsVert[n3] = this.m_iValidCellsVert[n3] + 1;
        }
    }
}

