/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.changeNoDataValue;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ChangeNoDataValueAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String INPUT = "INPUT";
    private static final String NO_DATA_VALUE = "NO_DATA_VALUE";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"ChangeNoDataValue"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Input_layer"), true);
            this.m_Parameters.addNumericalValue(NO_DATA_VALUE, Sextante.getText((String)"NoDataValue"), -99999.0, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer layer = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        double dNoData = this.m_Parameters.getParameterValueAsDouble(NO_DATA_VALUE);
        layer.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, layer.getName(), layer.getDataType(), layer.getLayerGridExtent());
        result.assign(layer);
        result.setNoDataValue(dNoData);
        return !this.m_Task.isCanceled();
    }
}

