/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.gradientLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.geom.Point2D;

public class GradientLinesAlgorithm
extends GeoAlgorithm {
    public static final String LINES = "LINES";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String SKIP = "SKIP";
    public static final String INPUT = "INPUT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Input;
    private IVectorLayer m_Lines;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Gradient_lines"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(MIN, Sextante.getText((String)"Minimum_size"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(MAX, Sextante.getText((String)"Maximum_size"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(SKIP, Sextante.getText((String)"Interval"), 1, 1.0, 0.0, 2.147483647E9);
            this.addOutputVectorLayer(LINES, Sextante.getText((String)"Gradient_lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dSlope;
        int x;
        int y;
        double dMin = Double.MAX_VALUE;
        double dMax = Double.NEGATIVE_INFINITY;
        Object[] values = new Object[2];
        String[] sFields = new String[]{Sextante.getText((String)"Slope"), Sextante.getText((String)"Aspect")};
        Class[] types = new Class[]{Double.class, Double.class};
        this.m_Input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Input.setFullExtent();
        int iSkip = this.m_Parameters.getParameterValueAsInt(SKIP);
        double dMinSize = this.m_Parameters.getParameterValueAsDouble(MIN);
        double dMaxSize = this.m_Parameters.getParameterValueAsDouble(MAX);
        double dRange = dMaxSize - dMinSize;
        this.m_Lines = this.getNewVectorLayer(LINES, this.m_Input.getName() + Sextante.getText((String)"[gradient]"), 1, types, sFields);
        this.m_iNX = this.m_Input.getNX();
        this.m_iNY = this.m_Input.getNY();
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); y += iSkip) {
            for (x = 0; x < this.m_iNX; x += iSkip) {
                dSlope = this.m_Input.getSlope(x, y);
                if (this.m_Input.isNoDataValue(dSlope)) continue;
                dMin = Math.min(dSlope, dMin);
                dMax = Math.max(dSlope, dMax);
            }
        }
        if (dMin < dMax) {
            dRange /= dMax - dMin;
        }
        GeometryFactory gf = new GeometryFactory();
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); y += iSkip) {
            for (x = 0; x < this.m_iNX; x += iSkip) {
                dSlope = this.m_Input.getSlope(x, y);
                double dAspect = this.m_Input.getAspect(x, y);
                if (this.m_Input.isNoDataValue(dSlope) || this.m_Input.isNoDataValue(dAspect)) continue;
                values[0] = new Double(dSlope);
                values[1] = new Double(dAspect);
                dSlope = dMin + dRange * (dSlope - dMin);
                Coordinate[] coords = new Coordinate[2];
                Point2D pt = this.m_Input.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
                coords[0] = new Coordinate(pt.getX(), pt.getY());
                double dX = pt.getX() + Math.sin(dAspect) * dSlope;
                double dY = pt.getY() + Math.cos(dAspect) * dSlope;
                coords[1] = new Coordinate(dX, dY);
                LineString line = gf.createLineString(coords);
                this.m_Lines.addFeature((Geometry)line, values);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

